/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.pades;

import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.pades.AbstractDSSFont;
import java.awt.Font;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DSSJavaFont
extends AbstractDSSFont {
    private static final Logger LOG = LoggerFactory.getLogger(DSSJavaFont.class);
    private static final int DEFAULT_FONT_STYLE = 0;

    public DSSJavaFont(Font javaFont) {
        this.javaFont = javaFont;
        this.size = javaFont.getSize();
    }

    public DSSJavaFont(String fontName) {
        this.javaFont = new Font(fontName, 0, 12);
    }

    public DSSJavaFont(String fontName, int size) {
        this.size = size;
        this.javaFont = new Font(fontName, 0, size);
    }

    public DSSJavaFont(String fontName, int style, int size) {
        this.size = size;
        this.javaFont = new Font(fontName, style, size);
    }

    @Override
    public InputStream getInputStream() {
        throw new DSSException("InputStream cannot be obtained from DSSJavaFont. Please use DSSFileFont implementation.");
    }

    @Override
    public String getName() {
        return this.javaFont.getFontName();
    }

    @Override
    public void setSize(float size) {
        this.size = size;
        this.javaFont = this.javaFont.deriveFont(size);
    }

    @Override
    public boolean isLogicalFont() {
        LOG.warn("The given font is logical (one of standart 14 fonts) and cannot be embedded to a PDF document. Please, use DSSFileFont implementation to get the document compatible with the PDF/A standard.");
        return true;
    }
}

