/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.model.x509;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.SignatureAlgorithm;
import eu.europa.esig.dss.model.identifier.TokenIdentifier;
import eu.europa.esig.dss.model.x509.CertificateToken;
import java.io.Serializable;
import java.security.PublicKey;
import java.util.Date;
import javax.security.auth.x500.X500Principal;

public abstract class Token
implements Serializable {
    private TokenIdentifier tokenIdentifier;
    protected PublicKey publicKeyOfTheSigner;
    protected boolean signatureValid = false;
    protected String signatureInvalidityReason = "";
    protected SignatureAlgorithm signatureAlgorithm;

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof Token)) {
            return false;
        }
        Token o2 = (Token)obj;
        return this.getDSSId().equals(o2.getDSSId());
    }

    public int hashCode() {
        return this.getDSSId().hashCode();
    }

    public boolean isSelfSigned() {
        return false;
    }

    public TokenIdentifier getDSSId() {
        if (this.tokenIdentifier == null) {
            this.tokenIdentifier = new TokenIdentifier(this);
        }
        return this.tokenIdentifier;
    }

    public String getDSSIdAsString() {
        return this.getDSSId().asXmlId();
    }

    public boolean isSignedBy(CertificateToken token) {
        if (this.publicKeyOfTheSigner != null) {
            return this.publicKeyOfTheSigner.equals(token.getPublicKey());
        }
        if (this.checkIsSignedBy(token)) {
            if (!this.isSelfSigned()) {
                this.publicKeyOfTheSigner = token.getPublicKey();
            }
            return true;
        }
        return false;
    }

    protected abstract boolean checkIsSignedBy(CertificateToken var1);

    public abstract X500Principal getIssuerX500Principal();

    public abstract Date getCreationDate();

    public String getAbbreviation() {
        return "?";
    }

    public SignatureAlgorithm getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public boolean isSignatureValid() {
        return this.signatureValid;
    }

    public PublicKey getPublicKeyOfTheSigner() {
        return this.publicKeyOfTheSigner;
    }

    public abstract String toString(String var1);

    public String toString() {
        return this.toString("");
    }

    public abstract byte[] getEncoded();

    public byte[] getDigest(DigestAlgorithm digestAlgorithm) {
        return this.getDSSId().getDigestValue(digestAlgorithm);
    }
}

