/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.model.x509;

import eu.europa.esig.dss.enumerations.KeyUsageBit;
import eu.europa.esig.dss.enumerations.SignatureAlgorithm;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.identifier.EntityIdentifier;
import eu.europa.esig.dss.model.x509.Token;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.security.auth.x500.X500Principal;

public class CertificateToken
extends Token {
    private final X509Certificate x509Certificate;
    private final String canonicalizedSubject;
    private final EntityIdentifier entityKey;
    private Boolean selfSigned;

    static CertificateToken newInstance(X509Certificate cert) {
        return new CertificateToken(cert);
    }

    public CertificateToken(X509Certificate x509Certificate) {
        Objects.requireNonNull(x509Certificate, "X509 certificate is missing");
        this.x509Certificate = x509Certificate;
        this.entityKey = new EntityIdentifier(x509Certificate.getPublicKey());
        this.canonicalizedSubject = x509Certificate.getSubjectX500Principal().getName("CANONICAL");
        this.signatureAlgorithm = SignatureAlgorithm.forOidAndParams(x509Certificate.getSigAlgOID(), x509Certificate.getSigAlgParams());
    }

    @Override
    public String getAbbreviation() {
        return this.getDSSIdAsString();
    }

    public String getEntityKey() {
        return this.entityKey.asXmlId();
    }

    public PublicKey getPublicKey() {
        return this.x509Certificate.getPublicKey();
    }

    public String getCanonicalizedSubject() {
        return this.canonicalizedSubject;
    }

    public Date getNotAfter() {
        return this.x509Certificate.getNotAfter();
    }

    public Date getNotBefore() {
        return this.x509Certificate.getNotBefore();
    }

    @Override
    public Date getCreationDate() {
        return this.getNotBefore();
    }

    public boolean isExpiredOn(Date date) {
        if (this.x509Certificate == null || date == null) {
            return true;
        }
        return this.x509Certificate.getNotAfter().before(date);
    }

    public boolean isValidOn(Date date) {
        if (this.x509Certificate == null || date == null) {
            return false;
        }
        try {
            this.x509Certificate.checkValidity(date);
            return true;
        }
        catch (CertificateExpiredException | CertificateNotYetValidException e) {
            return false;
        }
    }

    @Override
    public boolean isSelfSigned() {
        if (this.selfSigned == null) {
            this.selfSigned = this.isSelfIssued();
            if (this.selfSigned.booleanValue()) {
                try {
                    this.x509Certificate.verify(this.x509Certificate.getPublicKey());
                    this.selfSigned = true;
                    this.signatureValid = true;
                }
                catch (Exception e) {
                    this.selfSigned = false;
                }
            }
        }
        return this.selfSigned;
    }

    public boolean isSelfIssued() {
        String n1 = this.x509Certificate.getSubjectX500Principal().getName("CANONICAL");
        String n2 = this.x509Certificate.getIssuerX500Principal().getName("CANONICAL");
        return n1.equals(n2);
    }

    public boolean isEquivalent(CertificateToken token) {
        PublicKey currentPublicKey = this.getPublicKey();
        PublicKey tokenPublicKey = token.getPublicKey();
        return Arrays.equals(currentPublicKey.getEncoded(), tokenPublicKey.getEncoded());
    }

    public X509Certificate getCertificate() {
        return this.x509Certificate;
    }

    @Override
    public byte[] getEncoded() {
        try {
            return this.x509Certificate.getEncoded();
        }
        catch (CertificateEncodingException e) {
            throw new DSSException(e);
        }
    }

    public BigInteger getSerialNumber() {
        return this.x509Certificate.getSerialNumber();
    }

    public X500Principal getSubjectX500Principal() {
        return this.x509Certificate.getSubjectX500Principal();
    }

    @Override
    public X500Principal getIssuerX500Principal() {
        return this.x509Certificate.getIssuerX500Principal();
    }

    @Override
    protected boolean checkIsSignedBy(CertificateToken candidate) {
        this.signatureValid = false;
        this.signatureInvalidityReason = "";
        try {
            this.x509Certificate.verify(candidate.getPublicKey());
            this.signatureValid = true;
        }
        catch (InvalidKeyException e) {
            this.signatureInvalidityReason = "InvalidKeyException - on incorrect key.";
        }
        catch (CertificateException e) {
            this.signatureInvalidityReason = "CertificateException -  on encoding errors.";
        }
        catch (NoSuchAlgorithmException e) {
            this.signatureInvalidityReason = "NoSuchAlgorithmException - on unsupported signature algorithms.";
        }
        catch (SignatureException e) {
            this.signatureInvalidityReason = "SignatureException - on signature errors.";
        }
        catch (NoSuchProviderException e) {
            throw new DSSException(e);
        }
        return this.signatureValid;
    }

    public boolean checkKeyUsage(KeyUsageBit keyUsageBit) {
        List<KeyUsageBit> currentKUBs = this.getKeyUsageBits();
        return currentKUBs.contains((Object)keyUsageBit);
    }

    @Override
    public String toString(String indentStr) {
        StringBuilder out = new StringBuilder();
        out.append(indentStr).append("CertificateToken[\n");
        indentStr = indentStr + "\t";
        out.append(indentStr).append("DSS Id              : ").append(this.getDSSIdAsString()).append('\n');
        out.append(indentStr).append("Identity Id         : ").append(this.getEntityKey()).append('\n');
        out.append(indentStr).append("Validity period     : ").append(this.x509Certificate.getNotBefore()).append(" - ").append(this.x509Certificate.getNotAfter()).append('\n');
        out.append(indentStr).append("Subject name        : ").append(this.getSubjectX500Principal().getName("CANONICAL")).append('\n');
        out.append(indentStr).append("Issuer subject name : ").append(this.getIssuerX500Principal().getName("CANONICAL")).append('\n');
        out.append(indentStr).append("Serial Number       : ").append(this.getSerialNumber()).append('\n');
        out.append(indentStr).append("Signature algorithm : ").append(this.signatureAlgorithm == null ? "?" : this.signatureAlgorithm).append('\n');
        if (this.isSelfSigned()) {
            out.append(indentStr).append("[SELF-SIGNED]").append('\n');
        }
        indentStr = indentStr.substring(1);
        out.append(indentStr).append(']');
        return out.toString();
    }

    public List<KeyUsageBit> getKeyUsageBits() {
        ArrayList<KeyUsageBit> keyUsageBits = new ArrayList<KeyUsageBit>();
        boolean[] keyUsageArray = this.x509Certificate.getKeyUsage();
        if (keyUsageArray != null) {
            for (KeyUsageBit keyUsageBit : KeyUsageBit.values()) {
                if (!keyUsageArray[keyUsageBit.getIndex()]) continue;
                keyUsageBits.add(keyUsageBit);
            }
        }
        return keyUsageBits;
    }

    public boolean isCA() {
        return this.x509Certificate.getBasicConstraints() != -1;
    }

    public byte[] getSignature() {
        return this.x509Certificate.getSignature();
    }

    @Override
    public String getDSSIdAsString() {
        return "C-" + super.getDSSIdAsString();
    }
}

