/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.enumerations;

import java.util.ArrayList;

public enum TimestampType {
    CONTENT_TIMESTAMP(true, false, false, false),
    ALL_DATA_OBJECTS_TIMESTAMP(true, false, false, false),
    INDIVIDUAL_DATA_OBJECTS_TIMESTAMP(true, false, false, false),
    SIGNATURE_TIMESTAMP(false, true, false, false),
    VALIDATION_DATA_REFSONLY_TIMESTAMP(false, false, true, false),
    VALIDATION_DATA_TIMESTAMP(false, true, true, false),
    ARCHIVE_TIMESTAMP(false, true, true, true);

    private boolean contentTimestamp;
    private boolean coversSignarture;
    private boolean coversValidationData;
    private boolean archivalTimestamp;

    private TimestampType(boolean contentTimestamp, boolean coversSignature, boolean coversValidationData, boolean archivalTimestamp) {
        this.contentTimestamp = contentTimestamp;
        this.coversSignarture = coversSignature;
        this.coversValidationData = coversValidationData;
        this.archivalTimestamp = archivalTimestamp;
    }

    public boolean isContentTimestamp() {
        return this.contentTimestamp;
    }

    public boolean coversSignature() {
        return this.coversSignarture;
    }

    public boolean coversValidationData() {
        return this.coversValidationData;
    }

    public boolean isArchivalTimestamp() {
        return this.archivalTimestamp;
    }

    public static TimestampType[] getContentTimestampTypes() {
        ArrayList<TimestampType> contentTimestamps = new ArrayList<TimestampType>();
        for (TimestampType timestampType : TimestampType.values()) {
            if (!timestampType.isContentTimestamp()) continue;
            contentTimestamps.add(timestampType);
        }
        return contentTimestamps.toArray(new TimestampType[contentTimestamps.size()]);
    }

    public static TimestampType[] getTimestampTypesCoveringValidationData() {
        ArrayList<TimestampType> contentTimestamps = new ArrayList<TimestampType>();
        for (TimestampType timestampType : TimestampType.values()) {
            if (!timestampType.coversValidationData()) continue;
            contentTimestamps.add(timestampType);
        }
        return contentTimestamps.toArray(new TimestampType[contentTimestamps.size()]);
    }
}

