/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.diagnostic;

import eu.europa.esig.dss.diagnostic.CertificateRevocationWrapper;
import eu.europa.esig.dss.diagnostic.CertificateWrapper;
import eu.europa.esig.dss.diagnostic.RevocationWrapper;
import eu.europa.esig.dss.diagnostic.SignatureWrapper;
import eu.europa.esig.dss.diagnostic.TimestampWrapper;
import eu.europa.esig.dss.diagnostic.jaxb.XmlCertificate;
import eu.europa.esig.dss.diagnostic.jaxb.XmlContainerInfo;
import eu.europa.esig.dss.diagnostic.jaxb.XmlDiagnosticData;
import eu.europa.esig.dss.diagnostic.jaxb.XmlOrphanRevocation;
import eu.europa.esig.dss.diagnostic.jaxb.XmlOrphanToken;
import eu.europa.esig.dss.diagnostic.jaxb.XmlRevocation;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSignature;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSignerData;
import eu.europa.esig.dss.diagnostic.jaxb.XmlTimestamp;
import eu.europa.esig.dss.diagnostic.jaxb.XmlTrustedList;
import eu.europa.esig.dss.enumerations.CertificateSourceType;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.EncryptionAlgorithm;
import eu.europa.esig.dss.enumerations.MaskGenerationFunction;
import eu.europa.esig.dss.enumerations.OrphanTokenType;
import eu.europa.esig.dss.enumerations.RevocationReason;
import eu.europa.esig.dss.enumerations.RevocationType;
import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.enumerations.TimestampType;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DiagnosticData {
    private final XmlDiagnosticData wrapped;
    private List<SignatureWrapper> foundSignatures;
    private List<CertificateWrapper> usedCertificates;
    private List<TimestampWrapper> usedTimestamps;

    public DiagnosticData(XmlDiagnosticData wrapped) {
        this.wrapped = wrapped;
    }

    public String getDocumentName() {
        return this.wrapped.getDocumentName();
    }

    public List<String> getSignatureIdList() {
        ArrayList<String> signatureIds = new ArrayList<String>();
        List<XmlSignature> signatures = this.wrapped.getSignatures();
        if (signatures != null) {
            for (XmlSignature xmlSignature : signatures) {
                signatureIds.add(xmlSignature.getId());
            }
        }
        return signatureIds;
    }

    public String getFirstSignatureId() {
        SignatureWrapper firstSignature = this.getFirstSignatureNullSafe();
        return firstSignature.getId();
    }

    public Date getFirstSignatureDate() {
        SignatureWrapper firstSignature = this.getFirstSignatureNullSafe();
        return firstSignature.getDateTime();
    }

    public Date getSignatureDate(String signatureId) {
        SignatureWrapper signature = this.getSignatureByIdNullSafe(signatureId);
        return signature.getDateTime();
    }

    public SignatureLevel getFirstSignatureFormat() {
        SignatureWrapper signature = this.getFirstSignatureNullSafe();
        return signature.getSignatureFormat();
    }

    public SignatureLevel getSignatureFormat(String signatureId) {
        SignatureWrapper signature = this.getSignatureByIdNullSafe(signatureId);
        return signature.getSignatureFormat();
    }

    public DigestAlgorithm getFirstSignatureDigestAlgorithm() {
        SignatureWrapper signature = this.getFirstSignatureNullSafe();
        return signature.getDigestAlgorithm();
    }

    public DigestAlgorithm getSignatureDigestAlgorithm(String signatureId) {
        SignatureWrapper signature = this.getSignatureByIdNullSafe(signatureId);
        return signature.getDigestAlgorithm();
    }

    public EncryptionAlgorithm getFirstSignatureEncryptionAlgorithm() {
        SignatureWrapper signature = this.getFirstSignatureNullSafe();
        return signature.getEncryptionAlgorithm();
    }

    public EncryptionAlgorithm getSignatureEncryptionAlgorithm(String signatureId) {
        SignatureWrapper signature = this.getSignatureByIdNullSafe(signatureId);
        return signature.getEncryptionAlgorithm();
    }

    public MaskGenerationFunction getSignatureMaskGenerationFunction(String signatureId) {
        SignatureWrapper signature = this.getSignatureByIdNullSafe(signatureId);
        return signature.getMaskGenerationFunction();
    }

    public String getFirstSigningCertificateId() {
        SignatureWrapper signature = this.getFirstSignatureNullSafe();
        return signature.getSigningCertificate().getId();
    }

    public String getSigningCertificateId(String signatureId) {
        SignatureWrapper signature = this.getSignatureByIdNullSafe(signatureId);
        return signature.getSigningCertificate().getId();
    }

    public boolean isSigningCertificateIdentified(String signatureId) {
        SignatureWrapper signature = this.getSignatureByIdNullSafe(signatureId);
        return signature.isSigningCertificateIdentified();
    }

    public List<String> getSignatureCertificateChain(String signatureId) {
        SignatureWrapper signature = this.getSignatureByIdNullSafe(signatureId);
        ArrayList<String> result = new ArrayList<String>();
        for (CertificateWrapper certWrapper : signature.getCertificateChain()) {
            result.add(certWrapper.getId());
        }
        return result;
    }

    public String getFirstPolicyId() {
        SignatureWrapper signature = this.getFirstSignatureNullSafe();
        return signature.getPolicyId();
    }

    public String getPolicyId(String signatureId) {
        SignatureWrapper signature = this.getSignatureByIdNullSafe(signatureId);
        return signature.getPolicyId();
    }

    public String getPolicyDescription(String signatureId) {
        SignatureWrapper signature = this.getSignatureByIdNullSafe(signatureId);
        return signature.getPolicyDescription();
    }

    public List<String> getTimestampIdList(String signatureId) {
        SignatureWrapper signature = this.getSignatureByIdNullSafe(signatureId);
        return signature.getTimestampIdsList();
    }

    public List<TimestampWrapper> getTimestampList(String signatureId) {
        SignatureWrapper signature = this.getSignatureByIdNullSafe(signatureId);
        return signature.getTimestampList();
    }

    public boolean isBLevelTechnicallyValid(String signatureId) {
        SignatureWrapper signature = this.getSignatureByIdNullSafe(signatureId);
        return signature.isBLevelTechnicallyValid();
    }

    public boolean isThereTLevel(String signatureId) {
        SignatureWrapper signatureWrapper = this.getSignatureByIdNullSafe(signatureId);
        return signatureWrapper.isThereTLevel();
    }

    public boolean isTLevelTechnicallyValid(String signatureId) {
        SignatureWrapper signatureWrapper = this.getSignatureByIdNullSafe(signatureId);
        return signatureWrapper.isTLevelTechnicallyValid();
    }

    public boolean isThereXLevel(String signatureId) {
        SignatureWrapper signatureWrapper = this.getSignatureByIdNullSafe(signatureId);
        return signatureWrapper.isThereXLevel();
    }

    public boolean isXLevelTechnicallyValid(String signatureId) {
        SignatureWrapper signatureWrapper = this.getSignatureByIdNullSafe(signatureId);
        return signatureWrapper.isXLevelTechnicallyValid();
    }

    public boolean isThereALevel(String signatureId) {
        SignatureWrapper signatureWrapper = this.getSignatureByIdNullSafe(signatureId);
        return signatureWrapper.isThereALevel();
    }

    public boolean isALevelTechnicallyValid(String signatureId) {
        SignatureWrapper signatureWrapper = this.getSignatureByIdNullSafe(signatureId);
        return signatureWrapper.isALevelTechnicallyValid();
    }

    public String getTimestampSigningCertificateId(String timestampId) {
        TimestampWrapper timestamp = this.getTimestampByIdNullSafe(timestampId);
        return timestamp.getSigningCertificate().getId();
    }

    public TimestampType getTimestampType(String timestampId) {
        TimestampWrapper timestamp = this.getTimestampByIdNullSafe(timestampId);
        return timestamp.getType();
    }

    public boolean isValidCertificate(String dssCertificateId) {
        CertificateWrapper certificate = this.getUsedCertificateByIdNullSafe(dssCertificateId);
        boolean signatureValid = certificate.getCurrentBasicSignature() != null && certificate.getCurrentBasicSignature().isSignatureValid();
        CertificateRevocationWrapper latestRevocationData = this.getLatestRevocationDataForCertificate(certificate);
        boolean revocationValid = latestRevocationData != null && latestRevocationData.isStatus();
        boolean trusted = certificate.isTrusted();
        boolean validity = signatureValid && (trusted || revocationValid);
        return validity;
    }

    public String getCertificateDN(String dssCertificateId) {
        CertificateWrapper certificate = this.getUsedCertificateByIdNullSafe(dssCertificateId);
        return certificate.getCertificateDN();
    }

    public String getCertificateIssuerDN(String dssCertificateId) {
        CertificateWrapper certificate = this.getUsedCertificateByIdNullSafe(dssCertificateId);
        return certificate.getCertificateIssuerDN();
    }

    public String getCertificateSerialNumber(String dssCertificateId) {
        CertificateWrapper certificate = this.getUsedCertificateByIdNullSafe(dssCertificateId);
        return certificate.getSerialNumber();
    }

    public RevocationType getCertificateRevocationSource(String dssCertificateId) {
        CertificateWrapper certificate = this.getUsedCertificateByIdNullSafe(dssCertificateId);
        if (certificate.isRevocationDataAvailable()) {
            return this.getLatestRevocationDataForCertificate(certificate).getRevocationType();
        }
        return null;
    }

    public boolean getCertificateRevocationStatus(String dssCertificateId) {
        CertificateWrapper certificate = this.getUsedCertificateByIdNullSafe(dssCertificateId);
        if (certificate.isRevocationDataAvailable()) {
            return this.getLatestRevocationDataForCertificate(certificate).isStatus();
        }
        return false;
    }

    public RevocationReason getCertificateRevocationReason(String dssCertificateId) {
        CertificateWrapper certificate = this.getUsedCertificateByIdNullSafe(dssCertificateId);
        if (certificate.isRevocationDataAvailable()) {
            return this.getLatestRevocationDataForCertificate(certificate).getReason();
        }
        return null;
    }

    public String getErrorMessage(String signatureId) {
        SignatureWrapper signature = this.getSignatureByIdNullSafe(signatureId);
        return signature.getErrorMessage();
    }

    private SignatureWrapper getFirstSignatureNullSafe() {
        List<SignatureWrapper> signatures = this.getSignatures();
        if (signatures != null && signatures.size() > 0) {
            return signatures.get(0);
        }
        return new SignatureWrapper(new XmlSignature());
    }

    public SignatureWrapper getSignatureById(String id) {
        List<SignatureWrapper> signatures = this.getSignatures();
        if (signatures != null) {
            for (SignatureWrapper xmlSignature : signatures) {
                if (!id.equals(xmlSignature.getId())) continue;
                return xmlSignature;
            }
        }
        return null;
    }

    private SignatureWrapper getSignatureByIdNullSafe(String id) {
        List<SignatureWrapper> signatures = this.getSignatures();
        if (signatures != null) {
            for (SignatureWrapper xmlSignature : signatures) {
                if (!id.equals(xmlSignature.getId())) continue;
                return xmlSignature;
            }
        }
        return new SignatureWrapper(new XmlSignature());
    }

    private TimestampWrapper getTimestampByIdNullSafe(String id) {
        TimestampWrapper timestamp = this.getTimestampById(id);
        if (timestamp != null) {
            return timestamp;
        }
        return new TimestampWrapper(new XmlTimestamp());
    }

    public TimestampWrapper getTimestampById(String id) {
        Set<TimestampWrapper> allTimestamps = this.getTimestampSet();
        for (TimestampWrapper timestampWrapper : allTimestamps) {
            if (!id.equals(timestampWrapper.getId())) continue;
            return timestampWrapper;
        }
        return null;
    }

    public CertificateWrapper getUsedCertificateByIdNullSafe(String id) {
        CertificateWrapper cert = this.getUsedCertificateById(id);
        if (cert != null) {
            return cert;
        }
        return new CertificateWrapper(new XmlCertificate());
    }

    public CertificateWrapper getUsedCertificateById(String id) {
        List<CertificateWrapper> certificates = this.getUsedCertificates();
        if (certificates != null) {
            for (CertificateWrapper certificate : certificates) {
                if (!id.equals(certificate.getId())) continue;
                return certificate;
            }
        }
        return null;
    }

    public List<CertificateWrapper> getCertificatesFromSource(CertificateSourceType certificateSourceType) {
        ArrayList<CertificateWrapper> certificates = new ArrayList<CertificateWrapper>();
        for (CertificateWrapper certificate : this.getUsedCertificates()) {
            if (!certificate.getSources().contains((Object)certificateSourceType)) continue;
            certificates.add(certificate);
        }
        return certificates;
    }

    public List<XmlOrphanRevocation> getAllOrphanRevocations() {
        ArrayList<XmlOrphanRevocation> orphanRevocations = new ArrayList<XmlOrphanRevocation>();
        for (SignatureWrapper signatureWrapper : this.getSignatures()) {
            orphanRevocations.addAll(signatureWrapper.getOrphanRevocations());
        }
        return orphanRevocations;
    }

    public List<XmlOrphanToken> getAllOrphanCertificates() {
        ArrayList<XmlOrphanToken> orphanCertificateTokens = new ArrayList<XmlOrphanToken>();
        for (XmlOrphanToken orphanToken : this.wrapped.getOrphanTokens()) {
            if (!OrphanTokenType.CERTIFICATE.equals((Object)orphanToken.getType())) continue;
            orphanCertificateTokens.add(orphanToken);
        }
        return orphanCertificateTokens;
    }

    public List<SignatureWrapper> getSignatures() {
        if (this.foundSignatures == null) {
            this.foundSignatures = new ArrayList<SignatureWrapper>();
            List<XmlSignature> xmlSignatures = this.wrapped.getSignatures();
            if (xmlSignatures != null) {
                for (XmlSignature xmlSignature : xmlSignatures) {
                    this.foundSignatures.add(new SignatureWrapper(xmlSignature));
                }
            }
        }
        return this.foundSignatures;
    }

    public List<TimestampWrapper> getTimestampList() {
        if (this.usedTimestamps == null) {
            this.usedTimestamps = new ArrayList<TimestampWrapper>();
            List<XmlTimestamp> xmlTimestamps = this.wrapped.getUsedTimestamps();
            if (xmlTimestamps != null) {
                for (XmlTimestamp xmlTimestamp : xmlTimestamps) {
                    this.usedTimestamps.add(new TimestampWrapper(xmlTimestamp));
                }
            }
        }
        return this.usedTimestamps;
    }

    public List<CertificateWrapper> getUsedCertificates() {
        if (this.usedCertificates == null) {
            this.usedCertificates = new ArrayList<CertificateWrapper>();
            List<XmlCertificate> xmlCertificates = this.wrapped.getUsedCertificates();
            if (xmlCertificates != null) {
                for (XmlCertificate certificate : xmlCertificates) {
                    this.usedCertificates.add(new CertificateWrapper(certificate));
                }
            }
        }
        return this.usedCertificates;
    }

    public Set<SignatureWrapper> getAllSignatures() {
        HashSet<SignatureWrapper> signatures = new HashSet<SignatureWrapper>();
        List<SignatureWrapper> mixedSignatures = this.getSignatures();
        for (SignatureWrapper signatureWrapper : mixedSignatures) {
            if (signatureWrapper.getParent() != null) continue;
            signatures.add(signatureWrapper);
        }
        return signatures;
    }

    public Set<SignatureWrapper> getAllCounterSignatures() {
        HashSet<SignatureWrapper> signatures = new HashSet<SignatureWrapper>();
        List<SignatureWrapper> mixedSignatures = this.getSignatures();
        for (SignatureWrapper signatureWrapper : mixedSignatures) {
            if (signatureWrapper.getParent() == null) continue;
            signatures.add(signatureWrapper);
        }
        return signatures;
    }

    public Set<SignatureWrapper> getAllCounterSignaturesForMasterSignature(SignatureWrapper masterSignatureWrapper) {
        HashSet<SignatureWrapper> signatures = new HashSet<SignatureWrapper>();
        List<SignatureWrapper> mixedSignatures = this.getSignatures();
        for (SignatureWrapper signatureWrapper : mixedSignatures) {
            if (signatureWrapper.getParent() == null || !signatureWrapper.getParent().equals(masterSignatureWrapper)) continue;
            signatures.add(signatureWrapper);
        }
        return signatures;
    }

    public Set<TimestampWrapper> getTimestampSet() {
        return new HashSet<TimestampWrapper>(this.getTimestampList());
    }

    public Set<RevocationWrapper> getAllRevocationData() {
        HashSet<RevocationWrapper> revocationData = new HashSet<RevocationWrapper>();
        for (XmlRevocation xmlRevocation : this.wrapped.getUsedRevocations()) {
            revocationData.add(new RevocationWrapper(xmlRevocation));
        }
        return revocationData;
    }

    public CertificateRevocationWrapper getLatestRevocationDataForCertificate(CertificateWrapper certificate) {
        RevocationWrapper latest = null;
        List<CertificateRevocationWrapper> certificateRevocationData = certificate.getCertificateRevocationData();
        for (CertificateRevocationWrapper certRevoc : certificateRevocationData) {
            if (latest != null && (latest.getProductionDate() == null || certRevoc == null || certRevoc.getProductionDate() == null || !certRevoc.getProductionDate().after(latest.getProductionDate()))) continue;
            latest = certRevoc;
        }
        return latest;
    }

    public RevocationWrapper getRevocationById(String id) {
        for (RevocationWrapper revocationWrapper : this.getAllRevocationData()) {
            if (!id.equals(revocationWrapper.getId())) continue;
            return revocationWrapper;
        }
        return null;
    }

    public List<XmlSignerData> getOriginalSignerDocuments() {
        return this.wrapped.getOriginalDocuments();
    }

    public XmlDiagnosticData getJaxbModel() {
        return this.wrapped;
    }

    public boolean isContainerInfoPresent() {
        return this.wrapped.getContainerInfo() != null;
    }

    public String getContainerType() {
        XmlContainerInfo containerInfo = this.wrapped.getContainerInfo();
        if (containerInfo != null) {
            return containerInfo.getContainerType();
        }
        return null;
    }

    public String getZipComment() {
        XmlContainerInfo containerInfo = this.wrapped.getContainerInfo();
        if (containerInfo != null) {
            return containerInfo.getZipComment();
        }
        return null;
    }

    public boolean isMimetypeFilePresent() {
        XmlContainerInfo containerInfo = this.wrapped.getContainerInfo();
        if (containerInfo != null) {
            return containerInfo.isMimeTypeFilePresent();
        }
        return false;
    }

    public String getMimetypeFileContent() {
        XmlContainerInfo containerInfo = this.wrapped.getContainerInfo();
        if (containerInfo != null) {
            return containerInfo.getMimeTypeContent();
        }
        return null;
    }

    public XmlContainerInfo getContainerInfo() {
        return this.wrapped.getContainerInfo();
    }

    public List<XmlTrustedList> getTrustedLists() {
        return this.wrapped.getTrustedLists();
    }

    public XmlTrustedList getListOfTrustedLists() {
        return this.wrapped.getListOfTrustedLists();
    }

    public String getLOTLCountryCode() {
        XmlTrustedList listOfTrustedLists = this.wrapped.getListOfTrustedLists();
        if (listOfTrustedLists != null) {
            return listOfTrustedLists.getCountryCode();
        }
        return null;
    }

    public Date getValidationDate() {
        return this.wrapped.getValidationDate();
    }
}

