/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.diagnostic;

import eu.europa.esig.dss.diagnostic.AbstractTokenProxy;
import eu.europa.esig.dss.diagnostic.CertificateRevocationWrapper;
import eu.europa.esig.dss.diagnostic.TrustedServiceWrapper;
import eu.europa.esig.dss.diagnostic.jaxb.XmlBasicSignature;
import eu.europa.esig.dss.diagnostic.jaxb.XmlCertificate;
import eu.europa.esig.dss.diagnostic.jaxb.XmlCertificatePolicy;
import eu.europa.esig.dss.diagnostic.jaxb.XmlCertificateRevocation;
import eu.europa.esig.dss.diagnostic.jaxb.XmlChainItem;
import eu.europa.esig.dss.diagnostic.jaxb.XmlDigestAlgoAndValue;
import eu.europa.esig.dss.diagnostic.jaxb.XmlDistinguishedName;
import eu.europa.esig.dss.diagnostic.jaxb.XmlOID;
import eu.europa.esig.dss.diagnostic.jaxb.XmlSigningCertificate;
import eu.europa.esig.dss.diagnostic.jaxb.XmlTrustedService;
import eu.europa.esig.dss.diagnostic.jaxb.XmlTrustedServiceProvider;
import eu.europa.esig.dss.enumerations.CertificateSourceType;
import eu.europa.esig.dss.enumerations.ExtendedKeyUsage;
import eu.europa.esig.dss.enumerations.KeyUsageBit;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CertificateWrapper
extends AbstractTokenProxy {
    private final XmlCertificate certificate;

    public CertificateWrapper(XmlCertificate certificate) {
        this.certificate = certificate;
    }

    @Override
    public String getId() {
        return this.certificate.getId();
    }

    @Override
    protected XmlBasicSignature getCurrentBasicSignature() {
        return this.certificate.getBasicSignature();
    }

    @Override
    protected List<XmlChainItem> getCurrentCertificateChain() {
        return this.certificate.getCertificateChain();
    }

    @Override
    protected XmlSigningCertificate getCurrentSigningCertificate() {
        return this.certificate.getSigningCertificate();
    }

    public boolean isTrusted() {
        return this.certificate.isTrusted();
    }

    public boolean isSelfSigned() {
        return this.certificate.isSelfSigned();
    }

    public List<KeyUsageBit> getKeyUsages() {
        List<KeyUsageBit> keyUsageBits = this.certificate.getKeyUsageBits();
        if (keyUsageBits != null) {
            return keyUsageBits;
        }
        return Collections.emptyList();
    }

    public boolean isRevocationDataAvailable() {
        return this.certificate.getRevocations() != null && this.certificate.getRevocations().size() > 0;
    }

    public List<CertificateSourceType> getSources() {
        return this.certificate.getSources();
    }

    public List<CertificateRevocationWrapper> getCertificateRevocationData() {
        ArrayList<CertificateRevocationWrapper> certRevocationWrappers = new ArrayList<CertificateRevocationWrapper>();
        List<XmlCertificateRevocation> revocations = this.certificate.getRevocations();
        for (XmlCertificateRevocation xmlCertificateRevocation : revocations) {
            certRevocationWrappers.add(new CertificateRevocationWrapper(xmlCertificateRevocation));
        }
        return certRevocationWrappers;
    }

    public boolean isIdPkixOcspNoCheck() {
        return this.certificate.isIdPkixOcspNoCheck() != null && this.certificate.isIdPkixOcspNoCheck() != false;
    }

    public boolean isIdKpOCSPSigning() {
        List<XmlOID> extendedKeyUsages = this.certificate.getExtendedKeyUsages();
        if (extendedKeyUsages != null) {
            for (XmlOID xmlOID : extendedKeyUsages) {
                if (!ExtendedKeyUsage.OCSP_SIGNING.getOid().equals(xmlOID.getValue())) continue;
                return true;
            }
        }
        return false;
    }

    public Date getNotBefore() {
        return this.certificate.getNotBefore();
    }

    public Date getNotAfter() {
        return this.certificate.getNotAfter();
    }

    public Date getCertificateTSPServiceExpiredCertsRevocationInfo() {
        List<XmlTrustedServiceProvider> trustedServiceProviders = this.certificate.getTrustedServiceProviders();
        if (trustedServiceProviders != null) {
            for (XmlTrustedServiceProvider trustedServiceProvider : trustedServiceProviders) {
                List<XmlTrustedService> trustedServices = trustedServiceProvider.getTrustedServices();
                for (XmlTrustedService xmlTrustedService : trustedServices) {
                    if (xmlTrustedService.getExpiredCertsRevocationInfo() == null) continue;
                    return xmlTrustedService.getExpiredCertsRevocationInfo();
                }
            }
        }
        return null;
    }

    public String getSerialNumber() {
        BigInteger serialNumber = this.certificate.getSerialNumber();
        return serialNumber == null ? "" : serialNumber.toString();
    }

    public String getCommonName() {
        return this.certificate.getCommonName();
    }

    public String getCountryName() {
        return this.certificate.getCountryName();
    }

    public String getGivenName() {
        return this.certificate.getGivenName();
    }

    public String getOrganizationName() {
        return this.certificate.getOrganizationName();
    }

    public String getOrganizationalUnit() {
        return this.certificate.getOrganizationalUnit();
    }

    public String getEmail() {
        return this.certificate.getEmail();
    }

    public String getLocality() {
        return this.certificate.getLocality();
    }

    public String getState() {
        return this.certificate.getState();
    }

    public String getSurname() {
        return this.certificate.getSurname();
    }

    public String getPseudo() {
        return this.certificate.getPseudonym();
    }

    public XmlDigestAlgoAndValue getDigestAlgoAndValue() {
        return this.certificate.getDigestAlgoAndValue();
    }

    public boolean hasTrustedServices() {
        List<XmlTrustedServiceProvider> tsps = this.certificate.getTrustedServiceProviders();
        return tsps != null && tsps.size() > 0;
    }

    public List<XmlTrustedServiceProvider> getTrustServiceProviders() {
        return this.certificate.getTrustedServiceProviders();
    }

    public List<TrustedServiceWrapper> getTrustedServices() {
        ArrayList<TrustedServiceWrapper> result = new ArrayList<TrustedServiceWrapper>();
        List<XmlTrustedServiceProvider> tsps = this.certificate.getTrustedServiceProviders();
        if (tsps != null) {
            for (XmlTrustedServiceProvider tsp : tsps) {
                List<XmlTrustedService> trustedServices = tsp.getTrustedServices();
                if (trustedServices == null) continue;
                for (XmlTrustedService trustedService : trustedServices) {
                    TrustedServiceWrapper wrapper = new TrustedServiceWrapper();
                    wrapper.setTspName(tsp.getTSPName());
                    wrapper.setServiceDigitalIdentifier(new CertificateWrapper(trustedService.getServiceDigitalIdentifier()));
                    wrapper.setServiceName(trustedService.getServiceName());
                    wrapper.setCountryCode(tsp.getCountryCode());
                    wrapper.setStatus(trustedService.getStatus());
                    wrapper.setType(trustedService.getServiceType());
                    wrapper.setStartDate(trustedService.getStartDate());
                    wrapper.setEndDate(trustedService.getEndDate());
                    wrapper.setCapturedQualifiers(new ArrayList<String>(trustedService.getCapturedQualifiers()));
                    wrapper.setAdditionalServiceInfos(new ArrayList<String>(trustedService.getAdditionalServiceInfoUris()));
                    result.add(wrapper);
                }
            }
        }
        return result;
    }

    public String getCertificateDN() {
        return this.getFormat(this.certificate.getSubjectDistinguishedName(), "RFC2253");
    }

    public String getCertificateIssuerDN() {
        return this.getFormat(this.certificate.getIssuerDistinguishedName(), "RFC2253");
    }

    private String getFormat(List<XmlDistinguishedName> distinguishedNames, String format) {
        if (distinguishedNames != null) {
            for (XmlDistinguishedName distinguishedName : distinguishedNames) {
                if (!distinguishedName.getFormat().equals(format)) continue;
                return distinguishedName.getValue();
            }
        }
        return "";
    }

    public List<String> getAuthorityInformationAccessUrls() {
        return this.certificate.getAuthorityInformationAccessUrls();
    }

    public List<String> getCRLDistributionPoints() {
        return this.certificate.getCRLDistributionPoints();
    }

    public List<String> getOCSPAccessUrls() {
        return this.certificate.getOCSPAccessUrls();
    }

    public List<String> getCpsUrls() {
        ArrayList<String> result = new ArrayList<String>();
        List<XmlCertificatePolicy> certificatePolicyIds = this.certificate.getCertificatePolicies();
        if (certificatePolicyIds != null) {
            for (XmlCertificatePolicy xmlCertificatePolicy : certificatePolicyIds) {
                String cpsUrl = xmlCertificatePolicy.getCpsUrl();
                if (cpsUrl == null) continue;
                result.add(cpsUrl);
            }
        }
        return result;
    }

    public List<String> getPolicyIds() {
        List<XmlCertificatePolicy> certificatePolicyIds = this.certificate.getCertificatePolicies();
        return this.getOidValues(certificatePolicyIds);
    }

    public List<String> getQCStatementIds() {
        List<XmlOID> certificateQCStatementIds = this.certificate.getQCStatementIds();
        return this.getOidValues(certificateQCStatementIds);
    }

    public List<String> getQCTypes() {
        List<XmlOID> certificateQCTypeIds = this.certificate.getQCTypes();
        return this.getOidValues(certificateQCTypeIds);
    }

    private List<String> getOidValues(List<? extends XmlOID> xmlOids) {
        ArrayList<String> result = new ArrayList<String>();
        if (xmlOids != null) {
            for (XmlOID xmlOID : xmlOids) {
                result.add(xmlOID.getValue());
            }
        }
        return result;
    }

    public Set<String> getTrustedListCountryCodes() {
        HashSet<String> countryCodes = new HashSet<String>();
        List<XmlTrustedServiceProvider> trustedServiceProviders = this.certificate.getTrustedServiceProviders();
        for (XmlTrustedServiceProvider tsp : trustedServiceProviders) {
            countryCodes.add(tsp.getCountryCode());
        }
        return countryCodes;
    }

    @Override
    public byte[] getBinaries() {
        return this.certificate.getBase64Encoded();
    }

    public List<XmlOID> getExtendedKeyUsages() {
        return this.certificate.getExtendedKeyUsages();
    }

    public String getReadableCertificateName() {
        if (this.certificate.getCommonName() != null) {
            return this.certificate.getCommonName();
        }
        if (this.certificate.getGivenName() != null) {
            return this.certificate.getGivenName();
        }
        if (this.certificate.getSurname() != null) {
            return this.certificate.getSurname();
        }
        if (this.certificate.getPseudonym() != null) {
            return this.certificate.getPseudonym();
        }
        if (this.certificate.getOrganizationName() != null) {
            return this.certificate.getOrganizationName();
        }
        if (this.certificate.getOrganizationalUnit() != null) {
            return this.certificate.getOrganizationalUnit();
        }
        return "?";
    }
}

