/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.detailedreport;

import eu.europa.esig.dss.detailedreport.jaxb.XmlBasicBuildingBlocks;
import eu.europa.esig.dss.detailedreport.jaxb.XmlCertificate;
import eu.europa.esig.dss.detailedreport.jaxb.XmlChainItem;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraint;
import eu.europa.esig.dss.detailedreport.jaxb.XmlConstraintsConclusion;
import eu.europa.esig.dss.detailedreport.jaxb.XmlDetailedReport;
import eu.europa.esig.dss.detailedreport.jaxb.XmlName;
import eu.europa.esig.dss.detailedreport.jaxb.XmlProofOfExistence;
import eu.europa.esig.dss.detailedreport.jaxb.XmlSignature;
import eu.europa.esig.dss.detailedreport.jaxb.XmlSubXCV;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationCertificateQualification;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationProcessTimestamps;
import eu.europa.esig.dss.detailedreport.jaxb.XmlValidationSignatureQualification;
import eu.europa.esig.dss.detailedreport.jaxb.XmlXCV;
import eu.europa.esig.dss.enumerations.CertificateQualification;
import eu.europa.esig.dss.enumerations.Context;
import eu.europa.esig.dss.enumerations.Indication;
import eu.europa.esig.dss.enumerations.SignatureQualification;
import eu.europa.esig.dss.enumerations.SubIndication;
import eu.europa.esig.dss.enumerations.ValidationTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class DetailedReport {
    private final XmlDetailedReport jaxbDetailedReport;

    public DetailedReport(XmlDetailedReport jaxbDetailedReport) {
        this.jaxbDetailedReport = jaxbDetailedReport;
    }

    public Indication getBasicBuildingBlocksIndication(String tokenId) {
        XmlBasicBuildingBlocks bbb = this.getBasicBuildingBlockById(tokenId);
        if (bbb != null) {
            return bbb.getConclusion().getIndication();
        }
        return null;
    }

    public SubIndication getBasicBuildingBlocksSubIndication(String tokenId) {
        XmlBasicBuildingBlocks bbb = this.getBasicBuildingBlockById(tokenId);
        if (bbb != null) {
            return bbb.getConclusion().getSubIndication();
        }
        return null;
    }

    public List<String> getBasicBuildingBlocksCertChain(String tokenId) {
        List<XmlChainItem> chainItems;
        LinkedList<String> certIds = new LinkedList<String>();
        XmlBasicBuildingBlocks bbb = this.getBasicBuildingBlockById(tokenId);
        if (bbb != null && (chainItems = bbb.getCertificateChain().getChainItem()) != null) {
            for (XmlChainItem chainItem : chainItems) {
                certIds.add(chainItem.getId());
            }
        }
        return certIds;
    }

    public XmlBasicBuildingBlocks getBasicBuildingBlockById(String tokenId) {
        List<XmlBasicBuildingBlocks> basicBuildingBlocks = this.jaxbDetailedReport.getBasicBuildingBlocks();
        if (basicBuildingBlocks != null) {
            for (XmlBasicBuildingBlocks xmlBasicBuildingBlocks : basicBuildingBlocks) {
                if (!tokenId.equals(xmlBasicBuildingBlocks.getId())) continue;
                return xmlBasicBuildingBlocks;
            }
        }
        return null;
    }

    public int getBasicBuildingBlocksNumber() {
        return this.jaxbDetailedReport.getBasicBuildingBlocks().size();
    }

    public String getBasicBuildingBlocksSignatureId(int index) {
        XmlBasicBuildingBlocks bbb;
        List<XmlBasicBuildingBlocks> bbbs = this.jaxbDetailedReport.getBasicBuildingBlocks();
        if (bbbs != null && bbbs.size() >= index && (bbb = this.jaxbDetailedReport.getBasicBuildingBlocks().get(index)) != null) {
            return bbb.getId();
        }
        return null;
    }

    public List<String> getSignatureIds() {
        ArrayList<String> result = new ArrayList<String>();
        List<XmlBasicBuildingBlocks> bbbs = this.jaxbDetailedReport.getBasicBuildingBlocks();
        for (XmlBasicBuildingBlocks bbb : bbbs) {
            if (Context.SIGNATURE != bbb.getType() && Context.COUNTER_SIGNATURE != bbb.getType()) continue;
            result.add(bbb.getId());
        }
        return result;
    }

    public String getFirstSignatureId() {
        List<String> result = this.getSignatureIds();
        if (result.size() > 0) {
            return result.get(0);
        }
        return null;
    }

    public List<String> getTimestampIds() {
        ArrayList<String> result = new ArrayList<String>();
        List<XmlBasicBuildingBlocks> bbbs = this.jaxbDetailedReport.getBasicBuildingBlocks();
        for (XmlBasicBuildingBlocks bbb : bbbs) {
            if (Context.TIMESTAMP != bbb.getType()) continue;
            result.add(bbb.getId());
        }
        return result;
    }

    public List<String> getRevocationIds() {
        ArrayList<String> result = new ArrayList<String>();
        List<XmlBasicBuildingBlocks> bbbs = this.jaxbDetailedReport.getBasicBuildingBlocks();
        for (XmlBasicBuildingBlocks bbb : bbbs) {
            if (Context.REVOCATION != bbb.getType()) continue;
            result.add(bbb.getId());
        }
        return result;
    }

    public Date getBestSignatureTime(String signatureId) {
        XmlProofOfExistence proofOfExistence = this.getBestProofOfExistence(signatureId);
        if (proofOfExistence != null) {
            return proofOfExistence.getTime();
        }
        return null;
    }

    public XmlProofOfExistence getBestProofOfExistence(String signatureId) {
        XmlSignature xmlSignature = this.getXmlSignatureById(signatureId);
        if (xmlSignature != null) {
            if (xmlSignature.getValidationProcessArchivalData() != null) {
                return xmlSignature.getValidationProcessArchivalData().getProofOfExistence();
            }
            if (xmlSignature.getValidationProcessLongTermData() != null) {
                return xmlSignature.getValidationProcessLongTermData().getProofOfExistence();
            }
            if (xmlSignature.getValidationProcessBasicSignatures() != null) {
                return xmlSignature.getValidationProcessBasicSignatures().getProofOfExistence();
            }
        }
        return null;
    }

    public Indication getBasicValidationIndication(String signatureId) {
        XmlSignature signature = this.getXmlSignatureById(signatureId);
        if (signature != null && signature.getValidationProcessBasicSignatures() != null && signature.getValidationProcessBasicSignatures().getConclusion() != null) {
            return signature.getValidationProcessBasicSignatures().getConclusion().getIndication();
        }
        return null;
    }

    public SubIndication getBasicValidationSubIndication(String signatureId) {
        XmlSignature signature = this.getXmlSignatureById(signatureId);
        if (signature != null && signature.getValidationProcessBasicSignatures() != null && signature.getValidationProcessBasicSignatures().getConclusion() != null) {
            return signature.getValidationProcessBasicSignatures().getConclusion().getSubIndication();
        }
        return null;
    }

    public Indication getTimestampValidationIndication(String timestampId) {
        XmlValidationProcessTimestamps timestampValidationById = this.getTimestampValidationById(timestampId);
        if (timestampValidationById != null && timestampValidationById.getConclusion() != null) {
            return timestampValidationById.getConclusion().getIndication();
        }
        return null;
    }

    public SubIndication getTimestampValidationSubIndication(String timestampId) {
        XmlValidationProcessTimestamps timestampValidationById = this.getTimestampValidationById(timestampId);
        if (timestampValidationById != null && timestampValidationById.getConclusion() != null) {
            return timestampValidationById.getConclusion().getSubIndication();
        }
        return null;
    }

    public Indication getLongTermValidationIndication(String signatureId) {
        XmlSignature signature = this.getXmlSignatureById(signatureId);
        if (signature != null && signature.getValidationProcessLongTermData() != null && signature.getValidationProcessLongTermData().getConclusion() != null) {
            return signature.getValidationProcessLongTermData().getConclusion().getIndication();
        }
        return null;
    }

    public SubIndication getLongTermValidationSubIndication(String signatureId) {
        XmlSignature signature = this.getXmlSignatureById(signatureId);
        if (signature != null && signature.getValidationProcessLongTermData() != null && signature.getValidationProcessLongTermData().getConclusion() != null) {
            return signature.getValidationProcessLongTermData().getConclusion().getSubIndication();
        }
        return null;
    }

    public Indication getArchiveDataValidationIndication(String signatureId) {
        XmlSignature signature = this.getXmlSignatureById(signatureId);
        if (signature != null && signature.getValidationProcessArchivalData() != null && signature.getValidationProcessArchivalData().getConclusion() != null) {
            return signature.getValidationProcessArchivalData().getConclusion().getIndication();
        }
        return null;
    }

    public SubIndication getArchiveDataValidationSubIndication(String signatureId) {
        XmlSignature signature = this.getXmlSignatureById(signatureId);
        if (signature != null && signature.getValidationProcessArchivalData() != null && signature.getValidationProcessArchivalData().getConclusion() != null) {
            return signature.getValidationProcessArchivalData().getConclusion().getSubIndication();
        }
        return null;
    }

    public SignatureQualification getSignatureQualification(String signatureId) {
        XmlSignature signature = this.getXmlSignatureById(signatureId);
        if (signature != null && signature.getValidationSignatureQualification() != null) {
            return signature.getValidationSignatureQualification().getSignatureQualification();
        }
        return null;
    }

    public XmlSignature getXmlSignatureById(String signatureId) {
        List<XmlSignature> signatures = this.jaxbDetailedReport.getSignatures();
        if (signatures != null) {
            for (XmlSignature xmlSignature : signatures) {
                if (!signatureId.equals(xmlSignature.getId())) continue;
                return xmlSignature;
            }
        }
        return null;
    }

    private XmlValidationProcessTimestamps getTimestampValidationById(String timestampId) {
        List<XmlSignature> signatures = this.jaxbDetailedReport.getSignatures();
        if (signatures != null) {
            for (XmlSignature xmlSignature : signatures) {
                List<XmlValidationProcessTimestamps> validationTimestamps = xmlSignature.getValidationProcessTimestamps();
                if (validationTimestamps == null) continue;
                for (XmlValidationProcessTimestamps tspValidation : validationTimestamps) {
                    if (!timestampId.equals(tspValidation.getId())) continue;
                    return tspValidation;
                }
            }
        }
        return null;
    }

    public XmlDetailedReport getJAXBModel() {
        return this.jaxbDetailedReport;
    }

    public CertificateQualification getCertificateQualificationAtIssuance() {
        return this.getCertificateQualification(ValidationTime.CERTIFICATE_ISSUANCE_TIME);
    }

    public CertificateQualification getCertificateQualificationAtValidation() {
        return this.getCertificateQualification(ValidationTime.VALIDATION_TIME);
    }

    private CertificateQualification getCertificateQualification(ValidationTime validationTime) {
        List<XmlValidationCertificateQualification> validationCertificateQualifications;
        XmlCertificate certificate = this.jaxbDetailedReport.getCertificate();
        if (certificate != null && (validationCertificateQualifications = certificate.getValidationCertificateQualification()) != null) {
            for (XmlValidationCertificateQualification validationCertificateQualification : validationCertificateQualifications) {
                if (validationTime != validationCertificateQualification.getValidationTime()) continue;
                return validationCertificateQualification.getCertificateQualification();
            }
        }
        return CertificateQualification.NA;
    }

    public XmlConclusion getCertificateXCVConclusion(String certificateId) {
        if (this.jaxbDetailedReport.getCertificate() == null) {
            throw new UnsupportedOperationException("Only supported in report for certificate");
        }
        List<XmlBasicBuildingBlocks> basicBuildingBlocks = this.jaxbDetailedReport.getBasicBuildingBlocks();
        for (XmlBasicBuildingBlocks xmlBasicBuildingBlocks : basicBuildingBlocks) {
            XmlXCV xcv = xmlBasicBuildingBlocks.getXCV();
            if (xcv == null) continue;
            List<XmlSubXCV> subXCV = xcv.getSubXCV();
            for (XmlSubXCV xmlSubXCV : subXCV) {
                if (!certificateId.equals(xmlSubXCV.getId())) continue;
                return xmlSubXCV.getConclusion();
            }
            return xcv.getConclusion();
        }
        return null;
    }

    public Indication getHighestIndication(String signatureId) {
        return this.getHighestConclusion(signatureId).getConclusion().getIndication();
    }

    public SubIndication getHighestSubIndication(String signatureId) {
        return this.getHighestConclusion(signatureId).getConclusion().getSubIndication();
    }

    private XmlConstraintsConclusion getHighestConclusion(String signatureId) {
        XmlSignature xmlSignature = this.getXmlSignatureById(signatureId);
        if (xmlSignature.getValidationProcessArchivalData() != null) {
            return xmlSignature.getValidationProcessArchivalData();
        }
        if (xmlSignature.getValidationProcessLongTermData() != null) {
            return xmlSignature.getValidationProcessLongTermData();
        }
        return xmlSignature.getValidationProcessBasicSignatures();
    }

    public Set<String> getErrors(String signatureId) {
        return this.collect(MessageType.ERROR, signatureId);
    }

    public Set<String> getWarnings(String signatureId) {
        return this.collect(MessageType.WARN, signatureId);
    }

    public Set<String> getInfos(String signatureId) {
        return this.collect(MessageType.INFO, signatureId);
    }

    public Set<String> collect(MessageType type, String signatureId) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        XmlSignature signatureById = this.getXmlSignatureById(signatureId);
        XmlValidationSignatureQualification validationSignatureQualification = signatureById.getValidationSignatureQualification();
        if (validationSignatureQualification != null) {
            List<XmlValidationCertificateQualification> validationCertificateQualifications = validationSignatureQualification.getValidationCertificateQualification();
            for (XmlValidationCertificateQualification validationCertificateQualification : validationCertificateQualifications) {
                this.collect(type, result, validationCertificateQualification);
            }
            this.collect(type, result, validationSignatureQualification);
        }
        if (MessageType.ERROR == type) {
            this.collect(type, result, this.getHighestConclusion(signatureId));
            this.collectTimestamps(type, result, signatureById);
        } else {
            this.collect(type, result, signatureById.getValidationProcessBasicSignatures());
            this.collectTimestamps(type, result, signatureById);
            this.collect(type, result, signatureById.getValidationProcessLongTermData());
            this.collect(type, result, signatureById.getValidationProcessArchivalData());
        }
        return result;
    }

    private void collectTimestamps(MessageType type, Set<String> result, XmlSignature signatureById) {
        List<XmlValidationProcessTimestamps> validationProcessTimestamps = signatureById.getValidationProcessTimestamps();
        for (XmlValidationProcessTimestamps xmlValidationProcessTimestamp : validationProcessTimestamps) {
            if (MessageType.ERROR.equals((Object)type) && Indication.PASSED.equals(this.getBasicBuildingBlockById(xmlValidationProcessTimestamp.getId()).getConclusion().getIndication())) continue;
            this.collect(type, result, xmlValidationProcessTimestamp);
        }
    }

    private void collect(MessageType type, Set<String> result, XmlConstraintsConclusion constraintConclusion) {
        if (constraintConclusion != null && constraintConclusion.getConstraint() != null) {
            for (XmlConstraint constraint : constraintConclusion.getConstraint()) {
                String constraintId;
                XmlName message = this.getMessage(type, constraint);
                if (message != null) {
                    result.add(message.getValue());
                }
                if ((constraintId = constraint.getId()) == null || constraintId.isEmpty()) continue;
                this.collect(type, result, this.getBasicBuildingBlockById(constraintId));
            }
        }
    }

    private void collect(MessageType type, Set<String> result, XmlBasicBuildingBlocks bbb) {
        if (bbb != null) {
            this.collect(type, result, bbb.getFC());
            this.collect(type, result, bbb.getISC());
            this.collect(type, result, bbb.getCV());
            this.collect(type, result, bbb.getSAV());
            XmlXCV xcv = bbb.getXCV();
            if (xcv != null) {
                this.collect(type, result, xcv);
                List<XmlSubXCV> subXCV = xcv.getSubXCV();
                if (subXCV != null) {
                    for (XmlSubXCV xmlSubXCV : subXCV) {
                        this.collect(type, result, xmlSubXCV);
                    }
                }
            }
            this.collect(type, result, bbb.getVCI());
        }
    }

    private XmlName getMessage(MessageType type, XmlConstraint constraint) {
        XmlName message = null;
        switch (type) {
            case ERROR: {
                message = constraint.getError();
                break;
            }
            case WARN: {
                message = constraint.getWarning();
                break;
            }
            case INFO: {
                message = constraint.getInfo();
                break;
            }
        }
        return message;
    }

    public XmlSubXCV getSigningCertificate(String bbbId) {
        List<XmlSubXCV> subXCVs;
        XmlXCV xcv;
        XmlBasicBuildingBlocks basicBuildingBlocks = this.getBasicBuildingBlockById(bbbId);
        if (basicBuildingBlocks != null && (xcv = basicBuildingBlocks.getXCV()) != null && (subXCVs = xcv.getSubXCV()) != null && subXCVs.size() > 0) {
            return subXCVs.get(0);
        }
        return null;
    }

    static enum MessageType {
        INFO,
        WARN,
        ERROR;

    }
}

