/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.validation;

import eu.europa.esig.dss.cades.CMSUtils;
import eu.europa.esig.dss.cades.signature.CadesLevelBaselineLTATimestampExtractor;
import eu.europa.esig.dss.enumerations.ArchiveTimestampType;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.OID;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.timestamp.TimestampDataBuilder;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.BEROctetString;
import org.bouncycastle.asn1.BERSequence;
import org.bouncycastle.asn1.BERSet;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.SignedData;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.tsp.TimeStampToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CAdESTimestampDataBuilder
implements TimestampDataBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(CAdESTimestampDataBuilder.class);
    private final List<DSSDocument> detachedDocuments;
    private final SignerInformation signerInformation;
    private CMSSignedData cmsSignedData;
    private CadesLevelBaselineLTATimestampExtractor timestampExtractor;

    protected CAdESTimestampDataBuilder(SignerInformation signerInformation, List<DSSDocument> detachedDocuments) {
        this.signerInformation = signerInformation;
        this.detachedDocuments = detachedDocuments;
    }

    public CAdESTimestampDataBuilder(CMSSignedData cmsSignedData, SignerInformation signerInformation, List<DSSDocument> detachedDocuments, CadesLevelBaselineLTATimestampExtractor timestampExtractor) {
        this.cmsSignedData = cmsSignedData;
        this.signerInformation = signerInformation;
        this.detachedDocuments = detachedDocuments;
        this.timestampExtractor = timestampExtractor;
    }

    @Override
    public byte[] getContentTimestampData(TimestampToken timestampToken) {
        return DSSUtils.toByteArray(this.getOriginalDocument());
    }

    @Override
    public byte[] getSignatureTimestampData(TimestampToken timestampToken) {
        return this.signerInformation.getSignature();
    }

    @Override
    public byte[] getTimestampX1Data(TimestampToken timestampToken) {
        byte[] byArray;
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        try {
            data.write(this.signerInformation.getSignature());
            Attribute attribute = CMSUtils.getUnsignedAttribute(this.signerInformation, PKCSObjectIdentifiers.id_aa_signatureTimeStampToken);
            if (attribute != null) {
                data.write(DSSASN1Utils.getDEREncoded(attribute.getAttrType()));
                data.write(DSSASN1Utils.getDEREncoded(attribute.getAttrValues()));
            }
            data.write(this.getTimestampX2Data(timestampToken));
            byArray = data.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    data.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new DSSException(e);
            }
        }
        data.close();
        return byArray;
    }

    @Override
    public byte[] getTimestampX2Data(TimestampToken timestampToken) {
        byte[] byArray;
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        try {
            Attribute certAttribute = CMSUtils.getUnsignedAttribute(this.signerInformation, PKCSObjectIdentifiers.id_aa_ets_certificateRefs);
            Attribute revAttribute = CMSUtils.getUnsignedAttribute(this.signerInformation, PKCSObjectIdentifiers.id_aa_ets_revocationRefs);
            if (certAttribute != null) {
                data.write(DSSASN1Utils.getDEREncoded(certAttribute.getAttrType()));
                data.write(DSSASN1Utils.getDEREncoded(certAttribute.getAttrValues()));
            }
            if (revAttribute != null) {
                data.write(DSSASN1Utils.getDEREncoded(revAttribute.getAttrType()));
                data.write(DSSASN1Utils.getDEREncoded(revAttribute.getAttrValues()));
            }
            byArray = data.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    data.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new DSSException(e);
            }
        }
        data.close();
        return byArray;
    }

    @Override
    public byte[] getArchiveTimestampData(TimestampToken timestampToken) throws DSSException {
        byte[] archiveTimestampData;
        ArchiveTimestampType archiveTimestampType = timestampToken.getArchiveTimestampType();
        switch (archiveTimestampType) {
            case CAdES_V2: {
                archiveTimestampData = this.getArchiveTimestampDataV2(timestampToken, true);
                if (timestampToken.matchData(archiveTimestampData, true)) break;
                archiveTimestampData = this.getArchiveTimestampDataV2(timestampToken, false);
                break;
            }
            case CAdES_V3: {
                archiveTimestampData = this.getArchiveTimestampDataV3(timestampToken);
                break;
            }
            default: {
                throw new DSSException("Unsupported ArchiveTimestampType " + (Object)((Object)archiveTimestampType));
            }
        }
        return archiveTimestampData;
    }

    private byte[] getArchiveTimestampDataV3(TimestampToken timestampToken) throws DSSException {
        Attribute atsHashIndexAttribute = this.timestampExtractor.getVerifiedAtsHashIndex(this.signerInformation, timestampToken);
        DigestAlgorithm messageImprintDigestAlgorithm = timestampToken.getSignedDataDigestAlgo();
        byte[] originalDocumentDigest = this.getOriginalDocumentDigest(messageImprintDigestAlgorithm);
        return this.timestampExtractor.getArchiveTimestampDataV3(this.signerInformation, atsHashIndexAttribute, originalDocumentDigest);
    }

    private byte[] getOriginalDocumentDigest(DigestAlgorithm algo) {
        DSSDocument originalDocument = this.getOriginalDocument();
        return Utils.fromBase64(originalDocument.getDigest(algo));
    }

    private byte[] getArchiveTimestampDataV2(TimestampToken timestampToken, boolean includeUnsignedAttrsTagAndLength) throws DSSException {
        byte[] byArray;
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        try {
            byte[] result;
            byte[] crlDataBytes;
            byte[] certificateBytes;
            ContentInfo contentInfo = this.cmsSignedData.toASN1Structure();
            SignedData signedData = SignedData.getInstance(contentInfo.getContent());
            byte[] contentInfoBytes = this.getContentInfoBytes(signedData);
            data.write(contentInfoBytes);
            if (CMSUtils.isDetachedSignature(this.cmsSignedData)) {
                byte[] originalDocumentBinaries = this.getOriginalDocumentBinaries();
                data.write(originalDocumentBinaries);
            }
            if (Utils.isArrayNotEmpty(certificateBytes = this.getCertificateDataBytes(signedData))) {
                data.write(certificateBytes);
            }
            if (Utils.isArrayNotEmpty(crlDataBytes = this.getCRLDataBytes(signedData))) {
                data.write(crlDataBytes);
            }
            SignerInfo signerInfo = this.signerInformation.toASN1Structure();
            byte[] signerInfoBytes = this.getSignerInfoBytes(timestampToken, includeUnsignedAttrsTagAndLength, signerInfo);
            data.write(signerInfoBytes);
            byArray = result = data.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    data.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new DSSException(e);
            }
            catch (Exception e) {
                LOG.warn("When error in computing or in format the algorithm just continue...", e);
                return DSSUtils.EMPTY_BYTE_ARRAY;
            }
        }
        data.close();
        return byArray;
    }

    private byte[] getContentInfoBytes(SignedData signedData) {
        ContentInfo content = signedData.getEncapContentInfo();
        byte[] contentInfoBytes = content.getContent() instanceof BEROctetString ? DSSASN1Utils.getBEREncoded(content) : DSSASN1Utils.getDEREncoded(content);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Content Info: {}", (Object)DSSUtils.toHex(contentInfoBytes));
        }
        return contentInfoBytes;
    }

    private byte[] getOriginalDocumentBinaries() {
        byte[] originalDocumentBinaries = DSSUtils.toByteArray(this.getOriginalDocument());
        if (Utils.isArrayNotEmpty(originalDocumentBinaries)) {
            return originalDocumentBinaries;
        }
        throw new DSSException("Signature is detached and no original data provided.");
    }

    private byte[] getCertificateDataBytes(SignedData signedData) throws IOException {
        byte[] certificatesBytes = null;
        ASN1Set certificates = signedData.getCertificates();
        if (certificates != null) {
            certificatesBytes = certificates instanceof BERSet ? new BERTaggedObject(false, 0, new BERSequence(certificates.toArray())).getEncoded() : new DERTaggedObject(false, 0, new DERSequence(certificates.toArray())).getEncoded();
            if (LOG.isTraceEnabled()) {
                LOG.trace("Certificates: {}", (Object)DSSUtils.toHex(certificatesBytes));
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Certificates are not present in the SignedData.");
        }
        return certificatesBytes;
    }

    private byte[] getCRLDataBytes(SignedData signedData) throws IOException {
        byte[] crlBytes = null;
        ASN1Set crLs = signedData.getCRLs();
        if (crLs != null) {
            crlBytes = signedData.getCRLs() instanceof BERSet ? new BERTaggedObject(false, 1, new BERSequence(crLs.toArray())).getEncoded() : new DERTaggedObject(false, 1, new DERSequence(crLs.toArray())).getEncoded();
            if (LOG.isTraceEnabled()) {
                LOG.trace("CRLs: {}", (Object)DSSUtils.toHex(crlBytes));
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("CRLs are not present in the SignedData.");
        }
        return crlBytes;
    }

    private byte[] getSignerInfoBytes(TimestampToken timestampToken, boolean includeUnsignedAttrsTagAndLength, SignerInfo signerInfo) throws IOException {
        try (ByteArrayOutputStream signerByteArrayOutputStream = new ByteArrayOutputStream();){
            ASN1Set unauthenticatedAttributes = signerInfo.getUnauthenticatedAttributes();
            ASN1Sequence filteredUnauthenticatedAttributes = this.filterUnauthenticatedAttributes(unauthenticatedAttributes, timestampToken);
            ASN1Sequence asn1Object = this.getSignerInfoEncoded(signerInfo, filteredUnauthenticatedAttributes, includeUnsignedAttrsTagAndLength);
            for (int ii = 0; ii < asn1Object.size(); ++ii) {
                byte[] signerInfoBytes = DSSASN1Utils.getDEREncoded(asn1Object.getObjectAt(ii).toASN1Primitive());
                signerByteArrayOutputStream.write(signerInfoBytes);
            }
            byte[] signerInfoBytes = signerByteArrayOutputStream.toByteArray();
            if (LOG.isTraceEnabled()) {
                LOG.trace("SignerInfoBytes: {}", (Object)DSSUtils.toHex(signerInfoBytes));
            }
            byte[] byArray = signerInfoBytes;
            return byArray;
        }
    }

    private ASN1Sequence filterUnauthenticatedAttributes(ASN1Set unauthenticatedAttributes, TimestampToken timestampToken) {
        ASN1EncodableVector result = new ASN1EncodableVector();
        for (int ii = 0; ii < unauthenticatedAttributes.size(); ++ii) {
            Attribute attribute = Attribute.getInstance(unauthenticatedAttributes.getObjectAt(ii));
            ASN1ObjectIdentifier attrType = attribute.getAttrType();
            if (OID.id_aa_ets_archiveTimestampV2.equals(attrType) || OID.id_aa_ets_archiveTimestampV3.equals(attrType)) {
                try {
                    TimeStampToken token = DSSASN1Utils.getTimeStampToken(attribute);
                    if (!token.getTimeStampInfo().getGenTime().before(timestampToken.getGenerationTime())) {
                        continue;
                    }
                }
                catch (Exception e) {
                    throw new DSSException(e);
                }
            }
            result.add(unauthenticatedAttributes.getObjectAt(ii));
        }
        return new DERSequence(result);
    }

    private ASN1Sequence getSignerInfoEncoded(SignerInfo signerInfo, ASN1Sequence unauthenticatedAttributes, boolean includeUnsignedAttrsTagAndLength) {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(signerInfo.getVersion());
        v.add(signerInfo.getSID());
        v.add(signerInfo.getDigestAlgorithm());
        DERTaggedObject signedAttributes = CMSUtils.getDERSignedAttributes(this.signerInformation);
        if (signedAttributes != null) {
            v.add(signedAttributes);
        }
        v.add(signerInfo.getDigestEncryptionAlgorithm());
        v.add(signerInfo.getEncryptedDigest());
        if (unauthenticatedAttributes != null) {
            if (includeUnsignedAttrsTagAndLength) {
                v.add(new DERTaggedObject(false, 1, unauthenticatedAttributes));
            } else {
                for (int i = 0; i < unauthenticatedAttributes.size(); ++i) {
                    v.add(unauthenticatedAttributes.getObjectAt(i));
                }
            }
        }
        return new DERSequence(v);
    }

    private DSSDocument getOriginalDocument() {
        return CMSUtils.getOriginalDocument(this.cmsSignedData, this.detachedDocuments);
    }
}

