/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.validation;

import eu.europa.esig.dss.cades.CMSUtils;
import eu.europa.esig.dss.cades.SignerAttributeV2;
import eu.europa.esig.dss.cades.validation.CAdESCRLSource;
import eu.europa.esig.dss.cades.validation.CAdESOCSPSource;
import eu.europa.esig.dss.cades.validation.CAdESTimestampSource;
import eu.europa.esig.dss.cades.validation.PrecomputedDigestCalculatorProvider;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.DigestMatcherType;
import eu.europa.esig.dss.enumerations.EncryptionAlgorithm;
import eu.europa.esig.dss.enumerations.EndorsementType;
import eu.europa.esig.dss.enumerations.MaskGenerationFunction;
import eu.europa.esig.dss.enumerations.SignatureAlgorithm;
import eu.europa.esig.dss.enumerations.SignatureForm;
import eu.europa.esig.dss.enumerations.SignatureLevel;
import eu.europa.esig.dss.enumerations.TimestampedObjectType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.model.DigestDocument;
import eu.europa.esig.dss.model.identifier.TokenIdentifier;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.DSSSecurityProvider;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.OID;
import eu.europa.esig.dss.spi.x509.CertificatePool;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.CAdESCertificateSource;
import eu.europa.esig.dss.validation.CandidatesForSigningCertificate;
import eu.europa.esig.dss.validation.CertificateRef;
import eu.europa.esig.dss.validation.CertificateValidity;
import eu.europa.esig.dss.validation.CommitmentType;
import eu.europa.esig.dss.validation.DefaultAdvancedSignature;
import eu.europa.esig.dss.validation.IssuerSerialInfo;
import eu.europa.esig.dss.validation.ManifestEntry;
import eu.europa.esig.dss.validation.ManifestFile;
import eu.europa.esig.dss.validation.ReferenceValidation;
import eu.europa.esig.dss.validation.SignatureCRLSource;
import eu.europa.esig.dss.validation.SignatureCertificateSource;
import eu.europa.esig.dss.validation.SignatureCryptographicVerification;
import eu.europa.esig.dss.validation.SignatureDigestReference;
import eu.europa.esig.dss.validation.SignatureIdentifier;
import eu.europa.esig.dss.validation.SignatureOCSPSource;
import eu.europa.esig.dss.validation.SignaturePolicy;
import eu.europa.esig.dss.validation.SignaturePolicyProvider;
import eu.europa.esig.dss.validation.SignatureProductionPlace;
import eu.europa.esig.dss.validation.SignerRole;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import eu.europa.esig.dss.validation.timestamp.TimestampedReference;
import java.io.IOException;
import java.io.InputStream;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.ASN1UTCTime;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.esf.CommitmentTypeIndication;
import org.bouncycastle.asn1.esf.OtherHashAlgAndValue;
import org.bouncycastle.asn1.esf.SigPolicyQualifierInfo;
import org.bouncycastle.asn1.esf.SigPolicyQualifiers;
import org.bouncycastle.asn1.esf.SignaturePolicyId;
import org.bouncycastle.asn1.esf.SignerAttribute;
import org.bouncycastle.asn1.esf.SignerLocation;
import org.bouncycastle.asn1.ess.ContentHints;
import org.bouncycastle.asn1.ess.ContentIdentifier;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.RSASSAPSSparams;
import org.bouncycastle.asn1.x500.DirectoryString;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.AttCertValidityPeriod;
import org.bouncycastle.asn1.x509.AttributeCertificate;
import org.bouncycastle.asn1.x509.AttributeCertificateInfo;
import org.bouncycastle.asn1.x509.RoleSyntax;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataParser;
import org.bouncycastle.cms.CMSSignerDigestMismatchException;
import org.bouncycastle.cms.CMSTypedStream;
import org.bouncycastle.cms.SignerId;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationVerifier;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.bc.BcDigestCalculatorProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CAdESSignature
extends DefaultAdvancedSignature {
    private static final long serialVersionUID = 8449504364217200965L;
    private static final Logger LOG = LoggerFactory.getLogger(CAdESSignature.class);
    private static final Date JANUARY_1950 = DSSUtils.getUtcDate(1950, 1, 1);
    private static final Date JANUARY_2050 = DSSUtils.getUtcDate(2050, 1, 1);
    private final CMSSignedData cmsSignedData;
    private final SignerInformation signerInformation;
    private CertificateValidity signingCertificateValidity;

    public CAdESSignature(byte[] data) throws CMSException {
        this(data, new CertificatePool());
    }

    public CAdESSignature(byte[] data, CertificatePool certPool) throws CMSException {
        this(new CMSSignedData(data), certPool);
    }

    public CAdESSignature(CMSSignedData cms, CertificatePool certPool) {
        this(cms, DSSASN1Utils.getFirstSignerInformation(cms), certPool);
    }

    public CAdESSignature(CMSSignedData cms, CertificatePool certPool, List<DSSDocument> detachedContents) {
        this(cms, certPool);
        this.setDetachedContents(detachedContents);
    }

    public CAdESSignature(CMSSignedData cmsSignedData, SignerInformation signerInformation) {
        this(cmsSignedData, signerInformation, new CertificatePool());
    }

    public CAdESSignature(CMSSignedData cmsSignedData, SignerInformation signerInformation, CertificatePool certPool) {
        super(certPool);
        this.cmsSignedData = cmsSignedData;
        this.signerInformation = signerInformation;
    }

    @Override
    public SignatureForm getSignatureForm() {
        return SignatureForm.CAdES;
    }

    @Override
    public SignatureCertificateSource getCertificateSource() {
        if (this.offlineCertificateSource == null) {
            this.offlineCertificateSource = new CAdESCertificateSource(this.cmsSignedData, this.signerInformation, this.certPool);
        }
        return this.offlineCertificateSource;
    }

    @Override
    public SignatureCRLSource getCRLSource() {
        if (this.signatureCRLSource == null) {
            try {
                this.signatureCRLSource = new CAdESCRLSource(this.cmsSignedData, CMSUtils.getUnsignedAttributes(this.signerInformation));
            }
            catch (Exception e) {
                LOG.warn("Error in computing or in format of the algorithm: just continue...", e);
            }
        }
        return this.signatureCRLSource;
    }

    @Override
    public SignatureOCSPSource getOCSPSource() {
        if (this.signatureOCSPSource == null) {
            this.signatureOCSPSource = new CAdESOCSPSource(this.cmsSignedData, CMSUtils.getUnsignedAttributes(this.signerInformation));
        }
        return this.signatureOCSPSource;
    }

    @Override
    public CAdESTimestampSource getTimestampSource() {
        if (this.signatureTimestampSource == null) {
            this.signatureTimestampSource = new CAdESTimestampSource(this, this.certPool);
        }
        return (CAdESTimestampSource)this.signatureTimestampSource;
    }

    public SignerId getSignerId() {
        return this.signerInformation.getSID();
    }

    @Override
    public CandidatesForSigningCertificate getCandidatesForSigningCertificate() {
        if (this.candidatesForSigningCertificate != null) {
            return this.candidatesForSigningCertificate;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Searching the signing certificate...");
        }
        this.candidatesForSigningCertificate = new CandidatesForSigningCertificate();
        List<CertificateToken> keyInfoCertificates = this.getCertificateSource().getKeyInfoCertificates();
        SignerId signerId = this.getSignerId();
        for (CertificateToken certificateToken : keyInfoCertificates) {
            CertificateValidity certificateValidity = new CertificateValidity(certificateToken);
            this.candidatesForSigningCertificate.add(certificateValidity);
            X509CertificateHolder x509CertificateHolder = DSSASN1Utils.getX509CertificateHolder(certificateToken);
            boolean match = signerId.match(x509CertificateHolder);
            certificateValidity.setSignerIdMatch(match);
            if (!match) continue;
            this.signingCertificateValidity = certificateValidity;
            break;
        }
        if (this.signingCertificateValidity == null) {
            LOG.warn("Signing certificate not found: {} {}", (Object)signerId.getIssuer(), (Object)signerId.getSerialNumber());
        } else if (!this.verifySignedReferencesToSigningCertificate()) {
            LOG.warn("There is no valid signed reference to the signing certificate: {}", (Object)this.signingCertificateValidity.getCertificateToken().getAbbreviation());
        }
        return this.candidatesForSigningCertificate;
    }

    private boolean verifySignedReferencesToSigningCertificate() {
        List<CertificateRef> signingCertificateRefs = this.getCertificateSource().getSigningCertificateValues();
        if (Utils.isCollectionNotEmpty(signingCertificateRefs)) {
            this.signingCertificateValidity.setAttributePresent(true);
            CertificateToken foundSigningCertificate = this.signingCertificateValidity.getCertificateToken();
            for (CertificateRef certificateRef : signingCertificateRefs) {
                IssuerSerialInfo issuerInfo;
                Digest certDigest = certificateRef.getCertDigest();
                if (certDigest != null) {
                    byte[] expectedDigest = foundSigningCertificate.getDigest(certDigest.getAlgorithm());
                    this.signingCertificateValidity.setDigestPresent(true);
                    this.signingCertificateValidity.setDigestEqual(Arrays.equals(expectedDigest, certDigest.getValue()));
                }
                if ((issuerInfo = certificateRef.getIssuerInfo()) != null) {
                    this.signingCertificateValidity.setSerialNumberEqual(foundSigningCertificate.getSerialNumber().equals(issuerInfo.getSerialNumber()));
                    this.signingCertificateValidity.setDistinguishedNameEqual(DSSUtils.x500PrincipalAreEquals(foundSigningCertificate.getIssuerX500Principal(), issuerInfo.getIssuerName()));
                }
                if (!this.signingCertificateValidity.isDigestEqual()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void checkSignaturePolicy(SignaturePolicyProvider signaturePolicyProvider) {
        SigPolicyQualifiers sigPolicyQualifiers;
        Attribute attribute = this.getSignedAttribute(PKCSObjectIdentifiers.id_aa_ets_sigPolicyId);
        if (attribute == null) {
            return;
        }
        ASN1Encodable attrValue = attribute.getAttrValues().getObjectAt(0);
        if (attrValue instanceof DERNull) {
            this.signaturePolicy = new SignaturePolicy();
            return;
        }
        SignaturePolicyId sigPolicy = SignaturePolicyId.getInstance(attrValue);
        if (sigPolicy == null) {
            return;
        }
        String policyId = sigPolicy.getSigPolicyId().getId();
        this.signaturePolicy = new SignaturePolicy(policyId);
        OtherHashAlgAndValue hashAlgAndValue = sigPolicy.getSigPolicyHash();
        ASN1OctetString digestValue = hashAlgAndValue.getHashValue();
        byte[] digestValueBytes = digestValue.getOctets();
        boolean zeroHash = this.isZeroHash(digestValueBytes);
        this.signaturePolicy.setZeroHash(zeroHash);
        if (!zeroHash) {
            AlgorithmIdentifier digestAlgorithmIdentifier = hashAlgAndValue.getHashAlgorithm();
            String digestAlgorithmOID = digestAlgorithmIdentifier.getAlgorithm().getId();
            DigestAlgorithm digestAlgorithm = DigestAlgorithm.forOID(digestAlgorithmOID);
            this.signaturePolicy.setDigest(new Digest(digestAlgorithm, digestValueBytes));
        }
        if ((sigPolicyQualifiers = sigPolicy.getSigPolicyQualifiers()) == null) {
            this.signaturePolicy.setPolicyContent(signaturePolicyProvider.getSignaturePolicyById(policyId));
        } else {
            for (int ii = 0; ii < sigPolicyQualifiers.size(); ++ii) {
                try {
                    SigPolicyQualifierInfo policyQualifierInfo = sigPolicyQualifiers.getInfoAt(ii);
                    ASN1ObjectIdentifier policyQualifierInfoId = policyQualifierInfo.getSigPolicyQualifierId();
                    String policyQualifierInfoValue = policyQualifierInfo.getSigQualifier().toString();
                    if (PKCSObjectIdentifiers.id_spq_ets_unotice.equals(policyQualifierInfoId)) {
                        this.signaturePolicy.setNotice(policyQualifierInfoValue);
                        continue;
                    }
                    if (PKCSObjectIdentifiers.id_spq_ets_uri.equals(policyQualifierInfoId)) {
                        this.signaturePolicy.setUrl(policyQualifierInfoValue);
                        this.signaturePolicy.setPolicyContent(signaturePolicyProvider.getSignaturePolicyByUrl(policyQualifierInfoValue));
                        continue;
                    }
                    LOG.error("Unknown signature policy qualifier id: {} with value: {}", (Object)policyQualifierInfoId, (Object)policyQualifierInfoValue);
                    continue;
                }
                catch (Exception e) {
                    LOG.error("Unable to read SigPolicyQualifierInfo " + ii, (Object)e.getMessage());
                }
            }
            if (this.signaturePolicy.getPolicyContent() != null) {
                signaturePolicyProvider.getSignaturePoliciesById().put(policyId, this.signaturePolicy.getPolicyContent());
            }
        }
    }

    private boolean isZeroHash(byte[] hashValue) {
        return hashValue != null && hashValue.length == 1 && hashValue[0] == 0;
    }

    @Override
    public Date getSigningTime() {
        Attribute attr = this.getSignedAttribute(PKCSObjectIdentifiers.pkcs_9_at_signingTime);
        if (attr == null) {
            return null;
        }
        ASN1Set attrValues = attr.getAttrValues();
        ASN1Encodable attrValue = attrValues.getObjectAt(0);
        Date signingDate = DSSASN1Utils.getDate(attrValue);
        if (signingDate != null) {
            if (!(signingDate.before(JANUARY_1950) && signingDate.after(JANUARY_2050) || attrValue instanceof ASN1UTCTime)) {
                LOG.error("RFC 3852 states that dates between January 1, 1950 and December 31, 2049 (inclusive) must be encoded as UTCTime. Any dates with year values before 1950 or after 2049 must be encoded as GeneralizedTime. Date found is {} encoded as {}", (Object)signingDate, (Object)attrValue.getClass());
                return null;
            }
            return signingDate;
        }
        if (LOG.isErrorEnabled()) {
            LOG.error("Error when reading signing time. Unrecognized {}", (Object)attrValue.getClass());
        }
        return null;
    }

    public CMSSignedData getCmsSignedData() {
        return this.cmsSignedData;
    }

    @Override
    public SignatureProductionPlace getSignatureProductionPlace() {
        DirectoryString localityName;
        Attribute signatureProductionPlaceAttr = this.getSignedAttribute(PKCSObjectIdentifiers.id_aa_ets_signerLocation);
        if (signatureProductionPlaceAttr == null) {
            return null;
        }
        ASN1Encodable asn1Encodable = signatureProductionPlaceAttr.getAttrValues().getObjectAt(0);
        SignerLocation signerLocation = null;
        try {
            signerLocation = SignerLocation.getInstance(asn1Encodable);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), e);
        }
        if (signerLocation == null) {
            return null;
        }
        SignatureProductionPlace signatureProductionPlace = new SignatureProductionPlace();
        DirectoryString countryName = signerLocation.getCountry();
        if (countryName != null) {
            signatureProductionPlace.setCountryName(countryName.getString());
        }
        if ((localityName = signerLocation.getLocality()) != null) {
            signatureProductionPlace.setCity(localityName.getString());
        }
        StringBuilder address = new StringBuilder();
        ASN1Sequence seq = signerLocation.getPostalAddress();
        if (seq != null) {
            for (int ii = 0; ii < seq.size(); ++ii) {
                if (seq.getObjectAt(ii) instanceof DEROctetString) {
                    if (address.length() > 0) {
                        address.append(" / ");
                    }
                    address.append(new String(((DEROctetString)seq.getObjectAt(ii)).getOctets()));
                    continue;
                }
                if (!(seq.getObjectAt(ii) instanceof DERUTF8String)) continue;
                if (address.length() > 0) {
                    address.append(" / ");
                }
                DERUTF8String derutf8String = (DERUTF8String)seq.getObjectAt(ii);
                address.append(derutf8String.getString());
            }
        }
        signatureProductionPlace.setStreetAddress(address.toString());
        return signatureProductionPlace;
    }

    @Override
    public CommitmentType getCommitmentTypeIndication() {
        Attribute commitmentTypeIndicationAttribute = this.getSignedAttribute(PKCSObjectIdentifiers.id_aa_ets_commitmentType);
        if (commitmentTypeIndicationAttribute == null) {
            return null;
        }
        try {
            CommitmentType commitmentType = null;
            ASN1Set attrValues = commitmentTypeIndicationAttribute.getAttrValues();
            int size = attrValues.size();
            if (size > 0) {
                commitmentType = new CommitmentType();
                for (int ii = 0; ii < size; ++ii) {
                    if (attrValues.getObjectAt(ii) instanceof DERSequence) {
                        DERSequence derSequence = (DERSequence)attrValues.getObjectAt(ii);
                        CommitmentTypeIndication commitmentTypeIndication = CommitmentTypeIndication.getInstance(derSequence);
                        ASN1ObjectIdentifier commitmentTypeId = commitmentTypeIndication.getCommitmentTypeId();
                        commitmentType.addIdentifier(commitmentTypeId.getId());
                        continue;
                    }
                    LOG.warn("Unsupported type for CommitmentType : {}", (Object)attrValues.getObjectAt(ii).getClass());
                }
            }
            return commitmentType;
        }
        catch (Exception e) {
            throw new DSSException("Error when dealing with CommitmentTypeIndication!", e);
        }
    }

    @Override
    public List<SignerRole> getClaimedSignerRoles() {
        SignerAttribute signerAttr = this.getSignerAttributeV1();
        SignerAttributeV2 signerAttrV2 = this.getSignerAttributeV2();
        Object[] signerAttrValues = null;
        try {
            if (signerAttr != null) {
                signerAttrValues = signerAttr.getValues();
            } else if (signerAttrV2 != null) {
                signerAttrValues = signerAttrV2.getValues();
            }
            if (signerAttrValues == null) {
                return Collections.emptyList();
            }
            ArrayList<SignerRole> claimedRoles = new ArrayList<SignerRole>();
            for (Object signerAttrValue : signerAttrValues) {
                org.bouncycastle.asn1.x509.Attribute[] signerAttrValueArray;
                if (!(signerAttrValue instanceof org.bouncycastle.asn1.x509.Attribute[])) continue;
                for (org.bouncycastle.asn1.x509.Attribute claimedRole : signerAttrValueArray = (org.bouncycastle.asn1.x509.Attribute[])signerAttrValue) {
                    ASN1Encodable[] attrValues1;
                    for (ASN1Encodable asn1Encodable : attrValues1 = claimedRole.getAttrValues().toArray()) {
                        if (!(asn1Encodable instanceof ASN1String)) continue;
                        ASN1String asn1String = (ASN1String)((Object)asn1Encodable);
                        String role = asn1String.getString();
                        claimedRoles.add(new SignerRole(role, EndorsementType.CLAIMED));
                    }
                }
            }
            return claimedRoles;
        }
        catch (Exception e) {
            LOG.error("Error when dealing with claimed signer roles: [" + signerAttrValues + "]", e);
            return Collections.emptyList();
        }
    }

    @Override
    public List<SignerRole> getCertifiedSignerRoles() {
        SignerAttribute signerAttr = this.getSignerAttributeV1();
        SignerAttributeV2 signerAttrV2 = this.getSignerAttributeV2();
        Object[] signerAttrValues = null;
        try {
            if (signerAttr != null) {
                signerAttrValues = signerAttr.getValues();
            } else if (signerAttrV2 != null) {
                signerAttrValues = signerAttrV2.getValues();
            }
            if (signerAttrValues == null) {
                return Collections.emptyList();
            }
            ArrayList<SignerRole> roles = new ArrayList<SignerRole>();
            for (Object signerAttrValue : signerAttrValues) {
                if (!(signerAttrValue instanceof AttributeCertificate)) continue;
                AttributeCertificate attributeCertificate = (AttributeCertificate)signerAttrValue;
                AttributeCertificateInfo acInfo = attributeCertificate.getAcinfo();
                AttCertValidityPeriod attrCertValidityPeriod = acInfo.getAttrCertValidityPeriod();
                ASN1Sequence attributes = acInfo.getAttributes();
                for (int ii = 0; ii < attributes.size(); ++ii) {
                    ASN1Encodable objectAt = attributes.getObjectAt(ii);
                    org.bouncycastle.asn1.x509.Attribute attribute = org.bouncycastle.asn1.x509.Attribute.getInstance(objectAt);
                    ASN1Set attrValues1 = attribute.getAttrValues();
                    DERSequence derSequence = (DERSequence)attrValues1.getObjectAt(0);
                    RoleSyntax roleSyntax = RoleSyntax.getInstance(derSequence);
                    SignerRole certifiedRole = new SignerRole(roleSyntax.getRoleNameAsString(), EndorsementType.CERTIFIED);
                    certifiedRole.setNotBefore(DSSASN1Utils.toDate(attrCertValidityPeriod.getNotBeforeTime()));
                    certifiedRole.setNotAfter(DSSASN1Utils.toDate(attrCertValidityPeriod.getNotAfterTime()));
                    roles.add(certifiedRole);
                }
            }
            return roles;
        }
        catch (Exception e) {
            LOG.error("Error when dealing with certified signer roles: [" + signerAttrValues + "]", e);
            return Collections.emptyList();
        }
    }

    private SignerAttribute getSignerAttributeV1() {
        Attribute id_aa_ets_signerAttr = this.getSignedAttribute(PKCSObjectIdentifiers.id_aa_ets_signerAttr);
        if (id_aa_ets_signerAttr != null) {
            ASN1Set attrValues = id_aa_ets_signerAttr.getAttrValues();
            ASN1Encodable attrValue = attrValues.getObjectAt(0);
            try {
                return SignerAttribute.getInstance(attrValue);
            }
            catch (Exception e) {
                LOG.warn("Unable to parse signerAttr " + Utils.toBase64(DSSASN1Utils.getDEREncoded(attrValue)) + "", e);
            }
        }
        return null;
    }

    private SignerAttributeV2 getSignerAttributeV2() {
        Attribute id_aa_ets_signerAttrV2 = this.getSignedAttribute(OID.id_aa_ets_signerAttrV2);
        if (id_aa_ets_signerAttrV2 != null) {
            ASN1Set attrValues = id_aa_ets_signerAttrV2.getAttrValues();
            ASN1Encodable attrValue = attrValues.getObjectAt(0);
            try {
                return SignerAttributeV2.getInstance(attrValue);
            }
            catch (Exception e) {
                LOG.warn("Unable to parse signerAttrV2 " + Utils.toBase64(DSSASN1Utils.getDEREncoded(attrValue)) + "", e);
            }
        }
        return null;
    }

    public List<TimestampedReference> getTimestampReferencesForArchiveTimestamp(List<TimestampToken> timestampedTimestamps) {
        List<TimestampedReference> archiveReferences = this.getSignatureTimestampReferences();
        this.addReferencesForPreviousTimestamps(archiveReferences, timestampedTimestamps);
        this.addReferences(archiveReferences, this.getTimestampedReferences());
        return archiveReferences;
    }

    private List<TimestampedReference> getTimestampedReferences() {
        ArrayList<TimestampedReference> references = new ArrayList<TimestampedReference>();
        List<CertificateToken> certs = this.getCertificateSource().getCompleteCertificates();
        for (CertificateToken certificate : certs) {
            references.add(new TimestampedReference(certificate.getDSSIdAsString(), TimestampedObjectType.CERTIFICATE));
        }
        this.addReferencesFromRevocationData(references);
        return references;
    }

    @Override
    public EncryptionAlgorithm getEncryptionAlgorithm() {
        String oid = this.signerInformation.getEncryptionAlgOID();
        try {
            return EncryptionAlgorithm.forOID(oid);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.forOID(oid);
            return signatureAlgorithm.getEncryptionAlgorithm();
        }
    }

    @Override
    public DigestAlgorithm getDigestAlgorithm() {
        SignatureAlgorithm signatureAlgorithm = this.getEncryptedDigestAlgo();
        if (signatureAlgorithm != null) {
            if (SignatureAlgorithm.RSA_SSA_PSS_SHA1_MGF1.equals(signatureAlgorithm)) {
                return this.getPSSHashAlgorithm();
            }
            return signatureAlgorithm.getDigestAlgorithm();
        }
        try {
            String digestAlgOID = this.signerInformation.getDigestAlgOID();
            return DigestAlgorithm.forOID(digestAlgOID);
        }
        catch (IllegalArgumentException e) {
            LOG.warn(e.getMessage());
            return null;
        }
    }

    private SignatureAlgorithm getEncryptedDigestAlgo() {
        try {
            return SignatureAlgorithm.forOID(this.signerInformation.getEncryptionAlgOID());
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    public DigestAlgorithm getPSSHashAlgorithm() {
        try {
            byte[] encryptionAlgParams = this.signerInformation.getEncryptionAlgParams();
            if (Utils.isArrayNotEmpty(encryptionAlgParams) && !Arrays.equals(DERNull.INSTANCE.getEncoded(), encryptionAlgParams)) {
                RSASSAPSSparams param = RSASSAPSSparams.getInstance(encryptionAlgParams);
                AlgorithmIdentifier pssHashAlgo = param.getHashAlgorithm();
                return DigestAlgorithm.forOID(pssHashAlgo.getAlgorithm().getId());
            }
        }
        catch (IOException e) {
            LOG.warn("Unable to analyze EncryptionAlgParams", e);
        }
        return null;
    }

    @Override
    public MaskGenerationFunction getMaskGenerationFunction() {
        try {
            byte[] encryptionAlgParams;
            SignatureAlgorithm signatureAlgorithm = this.getEncryptedDigestAlgo();
            if (signatureAlgorithm != null && SignatureAlgorithm.RSA_SSA_PSS_SHA1_MGF1.equals(signatureAlgorithm) && Utils.isArrayNotEmpty(encryptionAlgParams = this.signerInformation.getEncryptionAlgParams()) && !Arrays.equals(DERNull.INSTANCE.getEncoded(), encryptionAlgParams)) {
                RSASSAPSSparams param = RSASSAPSSparams.getInstance(encryptionAlgParams);
                AlgorithmIdentifier maskGenAlgorithm = param.getMaskGenAlgorithm();
                if (PKCSObjectIdentifiers.id_mgf1.equals(maskGenAlgorithm.getAlgorithm())) {
                    return MaskGenerationFunction.MGF1;
                }
                LOG.warn("Unsupported mask algorithm : {}", (Object)maskGenAlgorithm.getAlgorithm());
            }
        }
        catch (IOException e) {
            LOG.warn("Unable to analyze EncryptionAlgParams", e);
        }
        return null;
    }

    @Override
    public SignatureAlgorithm getSignatureAlgorithm() {
        return SignatureAlgorithm.getAlgorithm(this.getEncryptionAlgorithm(), this.getDigestAlgorithm(), this.getMaskGenerationFunction());
    }

    @Override
    public void checkSignatureIntegrity() {
        if (this.signatureCryptographicVerification != null) {
            return;
        }
        this.signatureCryptographicVerification = new SignatureCryptographicVerification();
        try {
            SignerInformation signerInformationToCheck;
            CertificateValidity bestCandidate = this.getTheBestCandidate();
            if (bestCandidate == null) {
                this.signatureCryptographicVerification.setErrorMessage("There is no signing certificate within the signature.");
                return;
            }
            boolean detachedSignature = CMSUtils.isDetachedSignature(this.cmsSignedData);
            if (detachedSignature) {
                if (Utils.isCollectionEmpty(this.detachedContents)) {
                    this.candidatesForSigningCertificate.setTheCertificateValidity(bestCandidate);
                    this.signatureCryptographicVerification.setErrorMessage("Detached file not found!");
                    return;
                }
                signerInformationToCheck = this.recreateSignerInformation();
            } else {
                signerInformationToCheck = this.signerInformation;
            }
            LOG.debug("CHECK SIGNATURE VALIDITY: ");
            if (this.signingCertificateValidity != null) {
                try {
                    this.candidatesForSigningCertificate.setTheCertificateValidity(this.signingCertificateValidity);
                    JcaSimpleSignerInfoVerifierBuilder verifier = new JcaSimpleSignerInfoVerifierBuilder();
                    verifier.setProvider(DSSSecurityProvider.getSecurityProviderName());
                    CertificateToken certificateToken = this.signingCertificateValidity.getCertificateToken();
                    PublicKey publicKey = certificateToken.getPublicKey();
                    SignerInformationVerifier signerInformationVerifier = verifier.build(publicKey);
                    LOG.debug(" - WITH SIGNING CERTIFICATE: {}", (Object)certificateToken.getAbbreviation());
                    boolean signatureIntact = signerInformationToCheck.verify(signerInformationVerifier);
                    this.signatureCryptographicVerification.setSignatureIntact(signatureIntact);
                }
                catch (CMSSignerDigestMismatchException e) {
                    LOG.warn("Unable to validate CMS Signature : {}", (Object)e.getMessage());
                    this.signatureCryptographicVerification.setErrorMessage(e.getMessage());
                    this.signatureCryptographicVerification.setSignatureIntact(false);
                }
                catch (Exception e) {
                    LOG.error("Unable to validate CMS Signature : " + e.getMessage(), e);
                    this.signatureCryptographicVerification.setErrorMessage(e.getMessage());
                    this.signatureCryptographicVerification.setSignatureIntact(false);
                }
            }
            boolean referenceDataFound = true;
            boolean referenceDataIntact = true;
            List<ReferenceValidation> refValidations = this.getReferenceValidations(signerInformationToCheck);
            for (ReferenceValidation referenceValidation : refValidations) {
                referenceDataFound = referenceDataFound && referenceValidation.isFound();
                referenceDataIntact = referenceDataIntact && referenceValidation.isIntact();
            }
            this.signatureCryptographicVerification.setReferenceDataFound(referenceDataFound);
            this.signatureCryptographicVerification.setReferenceDataIntact(referenceDataIntact);
        }
        catch (IOException | CMSException e) {
            LOG.error(e.getMessage(), e);
            this.signatureCryptographicVerification.setErrorMessage(e.getMessage());
        }
        LOG.debug(" - RESULT: {}", (Object)this.signatureCryptographicVerification);
    }

    public List<ReferenceValidation> getReferenceValidations(SignerInformation signerInformationToCheck) {
        if (this.referenceValidations == null) {
            this.referenceValidations = new ArrayList();
            ReferenceValidation validation = new ReferenceValidation();
            validation.setType(DigestMatcherType.MESSAGE_DIGEST);
            DSSDocument originalDocument = null;
            try {
                originalDocument = this.getOriginalDocument();
            }
            catch (DSSException e) {
                validation.setFound(false);
            }
            Set<DigestAlgorithm> messageDigestAlgorithms = this.getMessageDigestAlgorithms();
            byte[] expectedMessageDigestValue = this.getMessageDigestValue();
            if (originalDocument != null) {
                if (Utils.isArrayNotEmpty(expectedMessageDigestValue)) {
                    Digest messageDigest = new Digest();
                    messageDigest.setValue(expectedMessageDigestValue);
                    validation.setFound(true);
                    if (Utils.isCollectionNotEmpty(messageDigestAlgorithms)) {
                        for (DigestAlgorithm digestAlgorithm : messageDigestAlgorithms) {
                            String base64Digest = originalDocument.getDigest(digestAlgorithm);
                            if (!Arrays.equals(expectedMessageDigestValue, Utils.fromBase64(base64Digest))) continue;
                            messageDigest.setAlgorithm(digestAlgorithm);
                            validation.setIntact(true);
                            break;
                        }
                        if (messageDigest.getAlgorithm() == null && messageDigestAlgorithms.size() == 1) {
                            messageDigest.setAlgorithm(messageDigestAlgorithms.iterator().next());
                        }
                        validation.setDigest(messageDigest);
                    } else {
                        LOG.warn("Message DigestAlgorithms not found in SignedData! Reference validation is not possible.");
                    }
                    if (validation.isFound()) {
                        validation.getDependentValidations().addAll(this.getManifestEntryValidation(originalDocument, messageDigest));
                    }
                } else {
                    LOG.warn("message-digest is not present in SignedData!");
                    if (signerInformationToCheck != null) {
                        LOG.warn("Extracting digests from content SignatureValue...");
                        validation = this.getContentReferenceValidation(originalDocument, signerInformationToCheck);
                    }
                }
            } else {
                LOG.warn("The original document is not found or cannot be extracted. Reference validation is not possible.");
            }
            this.referenceValidations.add(validation);
        }
        return this.referenceValidations;
    }

    private List<ReferenceValidation> getManifestEntryValidation(DSSDocument originalDocument, Digest messageDigest) {
        ArrayList<ReferenceValidation> manifestEntryValidations = new ArrayList<ReferenceValidation>();
        ManifestFile manifest = this.getSignedManifest(originalDocument, messageDigest);
        if (manifest == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No related manifest file found for a signature with name [{}]", (Object)this.getSignatureFilename());
            }
            return manifestEntryValidations;
        }
        for (ManifestEntry entry : manifest.getEntries()) {
            ReferenceValidation entryValidation = new ReferenceValidation();
            entryValidation.setType(DigestMatcherType.MANIFEST_ENTRY);
            entryValidation.setName(entry.getFileName());
            entryValidation.setDigest(entry.getDigest());
            entryValidation.setFound(entry.isFound());
            entryValidation.setIntact(entry.isIntact());
            manifestEntryValidations.add(entryValidation);
        }
        return manifestEntryValidations;
    }

    private ManifestFile getSignedManifest(DSSDocument originalDocument, Digest messageDigest) {
        if (Utils.isCollectionNotEmpty(this.manifestFiles)) {
            DigestAlgorithm digestAlgorithm = messageDigest.getAlgorithm() != null ? messageDigest.getAlgorithm() : DigestAlgorithm.SHA256;
            String digestValue = originalDocument.getDigest(digestAlgorithm);
            for (ManifestFile manifestFile : this.manifestFiles) {
                if (!digestValue.equals(manifestFile.getDigestBase64String(digestAlgorithm))) continue;
                return manifestFile;
            }
        }
        return null;
    }

    @Override
    public List<ReferenceValidation> getReferenceValidations() {
        return this.getReferenceValidations(null);
    }

    private ReferenceValidation getContentReferenceValidation(DSSDocument originalDocument, SignerInformation signerInformation) {
        byte[] contentDigest;
        ReferenceValidation contentValidation = new ReferenceValidation();
        contentValidation.setType(DigestMatcherType.CONTENT_DIGEST);
        DigestAlgorithm digestAlgorithm = this.getDigestAlgorithmForOID(signerInformation.getDigestAlgOID());
        if (originalDocument != null && digestAlgorithm != null && Utils.isArrayNotEmpty(contentDigest = signerInformation.getContentDigest())) {
            contentValidation.setFound(true);
            contentValidation.setDigest(new Digest(digestAlgorithm, contentDigest));
            if (Arrays.equals(contentDigest, Utils.fromBase64(originalDocument.getDigest(digestAlgorithm)))) {
                contentValidation.setIntact(true);
            }
        }
        return contentValidation;
    }

    @Override
    public SignatureDigestReference getSignatureDigestReference(DigestAlgorithm digestAlgorithm) {
        byte[] derEncodedSignerInfo = DSSASN1Utils.getDEREncoded(this.signerInformation.toASN1Structure());
        byte[] digestValue = DSSUtils.digest(digestAlgorithm, derEncodedSignerInfo);
        return new SignatureDigestReference(new Digest(digestAlgorithm, digestValue));
    }

    private SignerInformation recreateSignerInformation() throws CMSException, IOException {
        DSSDocument dssDocument = (DSSDocument)this.detachedContents.get(0);
        CMSSignedDataParser cmsSignedDataParser = null;
        if (dssDocument instanceof DigestDocument) {
            cmsSignedDataParser = new CMSSignedDataParser((DigestCalculatorProvider)new PrecomputedDigestCalculatorProvider((DigestDocument)dssDocument), this.cmsSignedData.getEncoded());
        } else {
            try (InputStream inputStream = dssDocument.openStream();){
                CMSTypedStream signedContent = new CMSTypedStream(inputStream);
                cmsSignedDataParser = new CMSSignedDataParser((DigestCalculatorProvider)new BcDigestCalculatorProvider(), signedContent, this.cmsSignedData.getEncoded());
                cmsSignedDataParser.getSignedContent().drain();
            }
        }
        SignerId signerId = this.getSignerId();
        SignerInformation signerInformationToCheck = cmsSignedDataParser.getSignerInfos().get(signerId);
        return signerInformationToCheck;
    }

    private CertificateValidity getTheBestCandidate() {
        if (this.providedSigningCertificateToken == null) {
            this.candidatesForSigningCertificate = this.getCandidatesForSigningCertificate();
        } else {
            this.candidatesForSigningCertificate = new CandidatesForSigningCertificate();
            CertificateValidity certificateValidity = new CertificateValidity(this.providedSigningCertificateToken);
            this.candidatesForSigningCertificate.add(certificateValidity);
        }
        return this.candidatesForSigningCertificate.getTheBestCandidate();
    }

    @Override
    public void checkSigningCertificate() {
    }

    public Set<DigestAlgorithm> getMessageDigestAlgorithms() {
        HashSet<DigestAlgorithm> result = new HashSet<DigestAlgorithm>();
        Set<AlgorithmIdentifier> digestAlgorithmIDs = this.cmsSignedData.getDigestAlgorithmIDs();
        for (AlgorithmIdentifier algorithmIdentifier : digestAlgorithmIDs) {
            String oid = algorithmIdentifier.getAlgorithm().getId();
            DigestAlgorithm digestAlgorithm = this.getDigestAlgorithmForOID(oid);
            if (digestAlgorithm == null) continue;
            result.add(DigestAlgorithm.forOID(oid));
        }
        return result;
    }

    private DigestAlgorithm getDigestAlgorithmForOID(String oid) {
        try {
            return DigestAlgorithm.forOID(oid);
        }
        catch (IllegalArgumentException e) {
            LOG.warn("Not a digest algorithm {} : {}", (Object)oid, (Object)e.getMessage());
            return null;
        }
    }

    @Override
    public byte[] getMessageDigestValue() {
        Attribute messageDigestAttribute = this.getSignedAttribute(PKCSObjectIdentifiers.pkcs_9_at_messageDigest);
        if (messageDigestAttribute == null) {
            return null;
        }
        ASN1OctetString asn1OctetString = (ASN1OctetString)messageDigestAttribute.getAttrValues().getObjectAt(0);
        return asn1OctetString.getOctets();
    }

    @Override
    public String getContentType() {
        Attribute contentTypeAttribute = this.getSignedAttribute(PKCSObjectIdentifiers.pkcs_9_at_contentType);
        if (contentTypeAttribute == null) {
            return null;
        }
        ASN1ObjectIdentifier oid = (ASN1ObjectIdentifier)contentTypeAttribute.getAttrValues().getObjectAt(0);
        return oid.getId();
    }

    @Override
    public String getMimeType() {
        Attribute mimeTypeAttribute = this.getSignedAttribute(OID.id_aa_ets_mimeType);
        if (mimeTypeAttribute == null) {
            return null;
        }
        return DSSASN1Utils.getString(mimeTypeAttribute.getAttrValues().getObjectAt(0));
    }

    @Override
    public String getContentIdentifier() {
        Attribute contentIdentifierAttribute = this.getSignedAttribute(PKCSObjectIdentifiers.id_aa_contentIdentifier);
        if (contentIdentifierAttribute == null) {
            return null;
        }
        ASN1Encodable asn1Encodable = contentIdentifierAttribute.getAttrValues().getObjectAt(0);
        ContentIdentifier contentIdentifier = ContentIdentifier.getInstance(asn1Encodable);
        String contentIdentifierString = DSSASN1Utils.toString(contentIdentifier.getValue());
        return contentIdentifierString;
    }

    @Override
    public String getContentHints() {
        Attribute contentHintAttribute = this.getSignedAttribute(PKCSObjectIdentifiers.id_aa_contentHint);
        if (contentHintAttribute == null) {
            return null;
        }
        ASN1Encodable asn1Encodable = contentHintAttribute.getAttrValues().getObjectAt(0);
        ContentHints contentHints = ContentHints.getInstance(asn1Encodable);
        String contentHint = null;
        if (contentHints != null) {
            contentHint = contentHints.getContentType().toString();
            if (contentHints.getContentDescription() != null) {
                contentHint = contentHint + " [" + contentHints.getContentDescription().toString() + "]";
            }
        }
        return contentHint;
    }

    public SignerInformation getSignerInformation() {
        return this.signerInformation;
    }

    @Override
    public byte[] getSignatureValue() {
        return this.signerInformation.getSignature();
    }

    @Override
    public List<AdvancedSignature> getCounterSignatures() {
        ArrayList<AdvancedSignature> countersignatures = new ArrayList<AdvancedSignature>();
        Iterator<SignerInformation> iterator = this.signerInformation.getCounterSignatures().getSigners().iterator();
        while (iterator.hasNext()) {
            SignerInformation signer;
            SignerInformation signerInformation = signer = iterator.next();
            CAdESSignature countersignature = new CAdESSignature(this.cmsSignedData, signerInformation, this.certPool);
            countersignature.setMasterSignature(this);
            countersignatures.add(countersignature);
        }
        return countersignatures;
    }

    @Override
    public List<CertificateRef> getCertificateRefs() {
        return this.getCertificateSource().getCompleteCertificateRefs();
    }

    public DSSDocument getOriginalDocument() throws DSSException {
        return CMSUtils.getOriginalDocument(this.cmsSignedData, this.detachedContents);
    }

    @Override
    protected SignatureIdentifier buildSignatureIdentifier() {
        CertificateToken certificateToken = this.getSigningCertificateToken();
        TokenIdentifier identifier = certificateToken == null ? null : certificateToken.getDSSId();
        Integer uniqueInteger = this.getUniqueIntegerIfNeeded();
        if (uniqueInteger == 0) {
            uniqueInteger = null;
        }
        String masterSignatureId = this.getMasterSignatureId();
        String fileName = this.getSignatureFilename();
        return SignatureIdentifier.buildSignatureIdentifier(this.getSigningTime(), identifier, uniqueInteger, masterSignatureId, fileName);
    }

    private String getMasterSignatureId() {
        AdvancedSignature masterSignature = this.getMasterSignature();
        if (masterSignature != null) {
            return masterSignature.getId();
        }
        return null;
    }

    private int getUniqueIntegerIfNeeded() {
        Collection<SignerInformation> signerInformations = this.getMasterSignature() == null ? this.cmsSignedData.getSignerInfos().getSigners(this.getSignerId()) : this.signerInformation.getCounterSignatures().getSigners(this.getSignerId());
        int counter = 0;
        for (SignerInformation signerInformation : signerInformations) {
            if (this.signerInformation == signerInformation) break;
            ++counter;
        }
        return counter;
    }

    @Override
    public String getDAIdentifier() {
        return null;
    }

    private Attribute getSignedAttribute(ASN1ObjectIdentifier oid) {
        AttributeTable signedAttributes = this.signerInformation.getSignedAttributes();
        if (signedAttributes == null) {
            return null;
        }
        return signedAttributes.get(oid);
    }

    @Override
    public boolean isDataForSignatureLevelPresent(SignatureLevel signatureLevel) {
        AttributeTable unsignedAttributes = CMSUtils.getUnsignedAttributes(this.signerInformation);
        AttributeTable signedAttributes = CMSUtils.getSignedAttributes(this.signerInformation);
        boolean dataForProfilePresent = true;
        switch (signatureLevel) {
            case CAdES_BASELINE_LTA: {
                dataForProfilePresent = this.hasLTAProfile();
                dataForProfilePresent = dataForProfilePresent && this.isDataForSignatureLevelPresent(SignatureLevel.CAdES_BASELINE_LT);
                break;
            }
            case CAdES_101733_A: {
                dataForProfilePresent = unsignedAttributes.get(OID.id_aa_ets_archiveTimestampV2) != null;
                dataForProfilePresent = dataForProfilePresent && this.isDataForSignatureLevelPresent(SignatureLevel.CAdES_BASELINE_LT);
                dataForProfilePresent = dataForProfilePresent && this.isDataForSignatureLevelPresent(SignatureLevel.CAdES_101733_X);
                break;
            }
            case CAdES_BASELINE_LT: {
                dataForProfilePresent = this.hasLTProfile();
                dataForProfilePresent = dataForProfilePresent && this.isDataForSignatureLevelPresent(SignatureLevel.CAdES_BASELINE_T);
                break;
            }
            case CAdES_101733_X: {
                dataForProfilePresent = unsignedAttributes.get(PKCSObjectIdentifiers.id_aa_ets_certCRLTimestamp) != null || unsignedAttributes.get(PKCSObjectIdentifiers.id_aa_ets_escTimeStamp) != null;
                dataForProfilePresent = dataForProfilePresent && this.isDataForSignatureLevelPresent(SignatureLevel.CAdES_101733_C);
                break;
            }
            case CAdES_101733_C: {
                dataForProfilePresent = unsignedAttributes.get(PKCSObjectIdentifiers.id_aa_ets_certificateRefs) != null;
                dataForProfilePresent = dataForProfilePresent && this.isDataForSignatureLevelPresent(SignatureLevel.CAdES_BASELINE_T);
                break;
            }
            case CAdES_BASELINE_T: {
                dataForProfilePresent = this.hasTProfile();
                dataForProfilePresent = dataForProfilePresent && this.isDataForSignatureLevelPresent(SignatureLevel.CAdES_BASELINE_B);
                break;
            }
            case CAdES_BASELINE_B: {
                dataForProfilePresent = signedAttributes.get(PKCSObjectIdentifiers.id_aa_signingCertificate) != null || signedAttributes.get(PKCSObjectIdentifiers.id_aa_signingCertificateV2) != null;
                break;
            }
            case CMS_NOT_ETSI: {
                dataForProfilePresent = true;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown level " + (Object)((Object)signatureLevel));
            }
        }
        return dataForProfilePresent;
    }

    @Override
    public SignatureLevel[] getSignatureLevels() {
        return new SignatureLevel[]{SignatureLevel.CMS_NOT_ETSI, SignatureLevel.CAdES_BASELINE_B, SignatureLevel.CAdES_BASELINE_T, SignatureLevel.CAdES_101733_C, SignatureLevel.CAdES_101733_X, SignatureLevel.CAdES_BASELINE_LT, SignatureLevel.CAdES_101733_A, SignatureLevel.CAdES_BASELINE_LTA};
    }
}

