/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.signature;

import eu.europa.esig.dss.spi.DSSUtils;
import java.io.ByteArrayOutputStream;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;

public class CustomContentSigner
implements ContentSigner {
    private byte[] preComputedSignature;
    private final AlgorithmIdentifier algorithmIdentifier;
    private ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();

    public CustomContentSigner(String algorithmIdentifier) {
        this(algorithmIdentifier, DSSUtils.EMPTY_BYTE_ARRAY);
    }

    public CustomContentSigner(String algorithmIdentifier, byte[] preComputedSignature) {
        this.algorithmIdentifier = new DefaultSignatureAlgorithmIdentifierFinder().find(algorithmIdentifier);
        this.preComputedSignature = preComputedSignature;
    }

    @Override
    public AlgorithmIdentifier getAlgorithmIdentifier() {
        return this.algorithmIdentifier;
    }

    @Override
    public ByteArrayOutputStream getOutputStream() {
        return this.byteOutputStream;
    }

    @Override
    public byte[] getSignature() {
        return this.preComputedSignature;
    }
}

