/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades.signature;

import eu.europa.esig.dss.cades.CAdESSignatureParameters;
import eu.europa.esig.dss.cades.CMSUtils;
import eu.europa.esig.dss.cades.SignerAttributeV2;
import eu.europa.esig.dss.model.Policy;
import eu.europa.esig.dss.model.SignerLocation;
import eu.europa.esig.dss.spi.DSSASN1Utils;
import eu.europa.esig.dss.spi.OID;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.esf.OtherHashAlgAndValue;
import org.bouncycastle.asn1.esf.SigPolicyQualifierInfo;
import org.bouncycastle.asn1.esf.SigPolicyQualifiers;
import org.bouncycastle.asn1.esf.SignaturePolicyId;
import org.bouncycastle.asn1.esf.SignaturePolicyIdentifier;
import org.bouncycastle.asn1.esf.SignerAttribute;
import org.bouncycastle.asn1.ess.ContentHints;
import org.bouncycastle.asn1.ess.ContentIdentifier;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Attribute;
import org.bouncycastle.asn1.x509.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CAdESLevelBaselineB {
    private static final Logger LOG = LoggerFactory.getLogger(CAdESLevelBaselineB.class);
    private final boolean padesUsage;

    public CAdESLevelBaselineB() {
        this(false);
    }

    public CAdESLevelBaselineB(boolean padesUsage) {
        this.padesUsage = padesUsage;
    }

    public AttributeTable getUnsignedAttributes() {
        return new AttributeTable(new Hashtable());
    }

    public AttributeTable getSignedAttributes(CAdESSignatureParameters parameters) {
        if (parameters.getSignedData() != null) {
            LOG.debug("Using explict SignedAttributes from parameter");
            return CMSUtils.getAttributesFromByteArray(parameters.getSignedData());
        }
        ASN1EncodableVector signedAttributes = new ASN1EncodableVector();
        this.addSigningCertificateAttribute(parameters, signedAttributes);
        this.addSigningTimeAttribute(parameters, signedAttributes);
        this.addSignerAttribute(parameters, signedAttributes);
        this.addSignaturePolicyId(parameters, signedAttributes);
        this.addContentHints(parameters, signedAttributes);
        this.addContentIdentifier(parameters, signedAttributes);
        this.addCommitmentType(parameters, signedAttributes);
        this.addSignerLocation(parameters, signedAttributes);
        this.addContentTimestamps(parameters, signedAttributes);
        AttributeTable signedAttributesTable = new AttributeTable(signedAttributes);
        return signedAttributesTable;
    }

    private void addSignerAttribute(CAdESSignatureParameters parameters, ASN1EncodableVector signedAttributes) {
        List<String> claimedSignerRoles = parameters.bLevel().getClaimedSignerRoles();
        if (claimedSignerRoles != null) {
            ArrayList<Attribute> claimedAttributes = new ArrayList<Attribute>(claimedSignerRoles.size());
            for (String claimedSignerRole : claimedSignerRoles) {
                DERUTF8String roles = new DERUTF8String(claimedSignerRole);
                Attribute id_aa_ets_signerAttr = new Attribute(OID.id_at_role, new DERSet(roles));
                claimedAttributes.add(id_aa_ets_signerAttr);
            }
            org.bouncycastle.asn1.cms.Attribute signerAttributes = !parameters.isEn319122() ? new org.bouncycastle.asn1.cms.Attribute(PKCSObjectIdentifiers.id_aa_ets_signerAttr, new DERSet(new SignerAttribute(claimedAttributes.toArray(new Attribute[claimedAttributes.size()])))) : new org.bouncycastle.asn1.cms.Attribute(OID.id_aa_ets_signerAttrV2, new DERSet(new SignerAttributeV2(claimedAttributes.toArray(new Attribute[claimedAttributes.size()]))));
            signedAttributes.add(signerAttributes);
        }
    }

    private void addSigningTimeAttribute(CAdESSignatureParameters parameters, ASN1EncodableVector signedAttributes) {
        if (this.padesUsage) {
            return;
        }
        Date signingDate = parameters.bLevel().getSigningDate();
        if (signingDate != null) {
            DERSet attrValues = new DERSet(new Time(signingDate));
            org.bouncycastle.asn1.cms.Attribute attribute = new org.bouncycastle.asn1.cms.Attribute(PKCSObjectIdentifiers.pkcs_9_at_signingTime, attrValues);
            signedAttributes.add(attribute);
        }
    }

    private void addSignerLocation(CAdESSignatureParameters parameters, ASN1EncodableVector signedAttributes) {
        if (this.padesUsage) {
            return;
        }
        SignerLocation signerLocationParameter = parameters.bLevel().getSignerLocation();
        if (signerLocationParameter != null) {
            DERUTF8String country = signerLocationParameter.getCountry() == null ? null : new DERUTF8String(signerLocationParameter.getCountry());
            DERUTF8String locality = signerLocationParameter.getLocality() == null ? null : new DERUTF8String(signerLocationParameter.getLocality());
            ASN1EncodableVector postalAddress = new ASN1EncodableVector();
            List<String> postalAddressParameter = signerLocationParameter.getPostalAddress();
            if (postalAddressParameter != null) {
                for (String addressLine : postalAddressParameter) {
                    postalAddress.add(new DERUTF8String(addressLine));
                }
            }
            DERSequence derSequencePostalAddress = new DERSequence(postalAddress);
            org.bouncycastle.asn1.esf.SignerLocation signerLocation = new org.bouncycastle.asn1.esf.SignerLocation(country, locality, (ASN1Sequence)derSequencePostalAddress);
            DERSet attrValues = new DERSet(signerLocation);
            org.bouncycastle.asn1.cms.Attribute attribute = new org.bouncycastle.asn1.cms.Attribute(PKCSObjectIdentifiers.id_aa_ets_signerLocation, attrValues);
            signedAttributes.add(attribute);
        }
    }

    private void addCommitmentType(CAdESSignatureParameters parameters, ASN1EncodableVector signedAttributes) {
        List<String> commitmentTypeIndications = parameters.bLevel().getCommitmentTypeIndications();
        if (Utils.isCollectionNotEmpty(commitmentTypeIndications)) {
            int size = commitmentTypeIndications.size();
            ASN1Encodable[] asn1Encodables = new ASN1Encodable[size];
            for (int ii = 0; ii < size; ++ii) {
                String commitmentTypeId = commitmentTypeIndications.get(ii);
                ASN1ObjectIdentifier objectIdentifier = new ASN1ObjectIdentifier(commitmentTypeId);
                asn1Encodables[ii] = new DERSequence(objectIdentifier);
            }
            DERSet attrValues = new DERSet(asn1Encodables);
            org.bouncycastle.asn1.cms.Attribute attribute = new org.bouncycastle.asn1.cms.Attribute(PKCSObjectIdentifiers.id_aa_ets_commitmentType, attrValues);
            signedAttributes.add(attribute);
        }
    }

    private void addContentTimestamps(CAdESSignatureParameters parameters, ASN1EncodableVector signedAttributes) {
        if (Utils.isCollectionNotEmpty(parameters.getContentTimestamps())) {
            List<TimestampToken> contentTimestamps = parameters.getContentTimestamps();
            for (TimestampToken contentTimestamp : contentTimestamps) {
                Object asn1Object = DSSASN1Utils.toASN1Primitive(contentTimestamp.getEncoded());
                DERSet attrValues = new DERSet((ASN1Encodable)asn1Object);
                org.bouncycastle.asn1.cms.Attribute attribute = new org.bouncycastle.asn1.cms.Attribute(PKCSObjectIdentifiers.id_aa_ets_contentTimestamp, attrValues);
                signedAttributes.add(attribute);
            }
        }
    }

    private void addContentHints(CAdESSignatureParameters parameters, ASN1EncodableVector signedAttributes) {
        if (Utils.isStringNotBlank(parameters.getContentHintsType())) {
            ASN1ObjectIdentifier contentHintsType = new ASN1ObjectIdentifier(parameters.getContentHintsType());
            String contentHintsDescriptionString = parameters.getContentHintsDescription();
            DERUTF8String contentHintsDescription = Utils.isStringBlank(contentHintsDescriptionString) ? null : new DERUTF8String(contentHintsDescriptionString);
            ContentHints contentHints = new ContentHints(contentHintsType, contentHintsDescription);
            DERSet attrValues = new DERSet(contentHints);
            org.bouncycastle.asn1.cms.Attribute attribute = new org.bouncycastle.asn1.cms.Attribute(PKCSObjectIdentifiers.id_aa_contentHint, attrValues);
            signedAttributes.add(attribute);
        }
    }

    private void addContentIdentifier(CAdESSignatureParameters parameters, ASN1EncodableVector signedAttributes) {
        if (this.padesUsage) {
            return;
        }
        String contentIdentifierPrefix = parameters.getContentIdentifierPrefix();
        if (Utils.isStringNotBlank(contentIdentifierPrefix)) {
            if (Utils.isStringBlank(parameters.getContentIdentifierSuffix())) {
                StringBuffer suffixBuffer = new StringBuffer();
                suffixBuffer.append(new ASN1GeneralizedTime(new Date()).getTimeString());
                suffixBuffer.append(new SecureRandom().nextLong());
                parameters.setContentIdentifierSuffix(suffixBuffer.toString());
            }
            String contentIdentifierString = contentIdentifierPrefix + parameters.getContentIdentifierSuffix();
            ContentIdentifier contentIdentifier = new ContentIdentifier(contentIdentifierString.getBytes());
            DERSet attrValues = new DERSet(contentIdentifier);
            org.bouncycastle.asn1.cms.Attribute attribute = new org.bouncycastle.asn1.cms.Attribute(PKCSObjectIdentifiers.id_aa_contentIdentifier, attrValues);
            signedAttributes.add(attribute);
        }
    }

    private void addSignaturePolicyId(CAdESSignatureParameters parameters, ASN1EncodableVector signedAttributes) {
        Policy policy = parameters.bLevel().getSignaturePolicy();
        if (policy != null) {
            String policyId = policy.getId();
            SignaturePolicyIdentifier sigPolicy = null;
            if (Utils.isStringEmpty(policyId)) {
                sigPolicy = new SignaturePolicyIdentifier();
            } else {
                ASN1ObjectIdentifier derOIPolicyId = new ASN1ObjectIdentifier(policyId);
                ASN1ObjectIdentifier oid = new ASN1ObjectIdentifier(policy.getDigestAlgorithm().getOid());
                AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(oid);
                OtherHashAlgAndValue otherHashAlgAndValue = new OtherHashAlgAndValue(algorithmIdentifier, new DEROctetString(policy.getDigestValue()));
                if (Utils.isStringNotEmpty(policy.getSpuri())) {
                    SigPolicyQualifierInfo policyQualifierInfo = new SigPolicyQualifierInfo(PKCSObjectIdentifiers.id_spq_ets_uri, new DERIA5String(policy.getSpuri()));
                    SigPolicyQualifierInfo[] qualifierInfos = new SigPolicyQualifierInfo[]{policyQualifierInfo};
                    SigPolicyQualifiers qualifiers = new SigPolicyQualifiers(qualifierInfos);
                    sigPolicy = new SignaturePolicyIdentifier(new SignaturePolicyId(derOIPolicyId, otherHashAlgAndValue, qualifiers));
                } else {
                    sigPolicy = new SignaturePolicyIdentifier(new SignaturePolicyId(derOIPolicyId, otherHashAlgAndValue));
                }
            }
            DERSet attrValues = new DERSet(sigPolicy);
            org.bouncycastle.asn1.cms.Attribute attribute = new org.bouncycastle.asn1.cms.Attribute(PKCSObjectIdentifiers.id_aa_ets_sigPolicyId, attrValues);
            signedAttributes.add(attribute);
        }
    }

    private void addSigningCertificateAttribute(CAdESSignatureParameters parameters, ASN1EncodableVector signedAttributes) {
        if (parameters.getSigningCertificate() == null && parameters.isGenerateTBSWithoutCertificate()) {
            LOG.debug("Signing certificate not available and must be added to signed attributes later");
            return;
        }
        CMSUtils.addSigningCertificateAttribute(signedAttributes, parameters.getDigestAlgorithm(), parameters.getSigningCertificate());
    }
}

