/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.cades;

import eu.europa.esig.dss.cades.CertifiedAttributesV2;
import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.x509.Attribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignerAttributeV2
extends ASN1Object {
    private static final Logger LOG = LoggerFactory.getLogger(SignerAttributeV2.class);
    private Object[] values;

    public static SignerAttributeV2 getInstance(Object o) {
        if (o instanceof SignerAttributeV2) {
            return (SignerAttributeV2)o;
        }
        if (o != null) {
            return new SignerAttributeV2(ASN1Sequence.getInstance(o));
        }
        return null;
    }

    private SignerAttributeV2(ASN1Sequence seq) {
        int index = 0;
        this.values = new Object[seq.size()];
        Enumeration e = seq.getObjects();
        while (e.hasMoreElements()) {
            ASN1TaggedObject taggedObject = ASN1TaggedObject.getInstance(e.nextElement());
            if (taggedObject.getTagNo() == 0) {
                ASN1Sequence attrs = ASN1Sequence.getInstance(taggedObject, true);
                Attribute[] attributes = new Attribute[attrs.size()];
                for (int i = 0; i != attributes.length; ++i) {
                    attributes[i] = Attribute.getInstance(attrs.getObjectAt(i));
                }
                this.values[index] = attributes;
            } else if (taggedObject.getTagNo() == 1) {
                this.values[index] = CertifiedAttributesV2.getInstance(ASN1Sequence.getInstance(taggedObject, true));
            } else if (taggedObject.getTagNo() == 2) {
                LOG.info("SAML assertion detected");
            } else {
                throw new IllegalArgumentException("illegal tag: " + taggedObject.getTagNo());
            }
            ++index;
        }
    }

    public SignerAttributeV2(Attribute[] claimedAttributes) {
        this.values = new Object[1];
        this.values[0] = claimedAttributes;
    }

    public SignerAttributeV2(CertifiedAttributesV2 certifiedAttributes) {
        this.values = new Object[1];
        this.values[0] = certifiedAttributes;
    }

    public Object[] getValues() {
        Object[] rv = new Object[this.values.length];
        System.arraycopy(this.values, 0, rv, 0, rv.length);
        return rv;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        for (int i = 0; i != this.values.length; ++i) {
            if (this.values[i] instanceof Attribute[]) {
                v.add(new DERTaggedObject(0, new DERSequence((Attribute[])this.values[i])));
                continue;
            }
            if (this.values[i] instanceof CertifiedAttributesV2) {
                v.add(new DERTaggedObject(1, (CertifiedAttributesV2)this.values[i]));
                continue;
            }
            LOG.warn("Unsupported type {}", this.values[i]);
        }
        return new DERSequence(v);
    }
}

