/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.xades;

import eu.europa.esig.dss.asic.common.ASiCExtractResult;
import eu.europa.esig.dss.model.DSSDocument;
import java.util.ArrayList;
import java.util.List;

public final class OpenDocumentSupportUtils {
    private static final String EXTERNAL_DATA = "external-data/";

    private OpenDocumentSupportUtils() {
    }

    public static List<DSSDocument> getOpenDocumentCoverage(ASiCExtractResult extractResult) {
        ArrayList<DSSDocument> docs = new ArrayList<DSSDocument>();
        docs.add(extractResult.getMimeTypeDocument());
        docs.addAll(extractResult.getSignedDocuments());
        docs.addAll(extractResult.getManifestDocuments());
        docs.addAll(extractResult.getArchiveManifestDocuments());
        docs.addAll(extractResult.getTimestampDocuments());
        docs.addAll(extractResult.getUnsupportedDocuments());
        ArrayList<DSSDocument> result = new ArrayList<DSSDocument>();
        for (DSSDocument doc : docs) {
            if (doc.getName().startsWith(EXTERNAL_DATA)) continue;
            result.add(doc);
        }
        return result;
    }
}

