/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.cades.validation.scope;

import eu.europa.esig.dss.cades.validation.CAdESSignature;
import eu.europa.esig.dss.cades.validation.scope.CAdESSignatureScopeFinder;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.Digest;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.scope.ContainerContentSignatureScope;
import eu.europa.esig.dss.validation.scope.ContainerSignatureScope;
import eu.europa.esig.dss.validation.scope.FullSignatureScope;
import eu.europa.esig.dss.validation.scope.ManifestSignatureScope;
import eu.europa.esig.dss.validation.scope.SignatureScope;
import java.util.ArrayList;
import java.util.List;

public class ASiCWithCAdESSignatureScopeFinder
extends CAdESSignatureScopeFinder {
    @Override
    public List<SignatureScope> findSignatureScope(CAdESSignature cadesSignature) {
        ArrayList<SignatureScope> result = new ArrayList<SignatureScope>();
        DSSDocument originalDocument = this.getOriginalDocument(cadesSignature);
        if (originalDocument == null) {
            return result;
        }
        if (this.isASiCSArchive(cadesSignature, originalDocument)) {
            result.add(new ContainerSignatureScope(originalDocument.getName(), this.getDigest(DSSUtils.toByteArray(originalDocument))));
            for (DSSDocument archivedDocument : cadesSignature.getContainerContents()) {
                result.add(new ContainerContentSignatureScope(DSSUtils.decodeUrl(archivedDocument.getName()), new Digest(this.getDefaultDigestAlgorithm(), Utils.fromBase64(archivedDocument.getDigest(this.getDefaultDigestAlgorithm())))));
            }
        } else if (this.isASiCEArchive(cadesSignature)) {
            result.add(new ManifestSignatureScope(originalDocument.getName(), this.getDigest(DSSUtils.toByteArray(originalDocument))));
            for (DSSDocument manifestContent : cadesSignature.getManifestedDocuments()) {
                result.add(new FullSignatureScope(manifestContent.getName(), new Digest(this.getDefaultDigestAlgorithm(), Utils.fromBase64(manifestContent.getDigest(this.getDefaultDigestAlgorithm())))));
            }
        } else {
            return this.getSignatureScopeFromOriginalDocument(originalDocument);
        }
        return result;
    }
}

