/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.cades.validation;

import eu.europa.esig.dss.asic.cades.ASiCWithCAdESContainerExtractor;
import eu.europa.esig.dss.asic.cades.validation.ASiCEWithCAdESManifestParser;
import eu.europa.esig.dss.asic.cades.validation.ASiCEWithCAdESManifestValidator;
import eu.europa.esig.dss.asic.cades.validation.ASiCEWithCAdESTimestampValidator;
import eu.europa.esig.dss.asic.cades.validation.CMSDocumentForASiCValidator;
import eu.europa.esig.dss.asic.common.ASiCUtils;
import eu.europa.esig.dss.asic.common.AbstractASiCContainerExtractor;
import eu.europa.esig.dss.asic.common.validation.AbstractASiCContainerValidator;
import eu.europa.esig.dss.cades.validation.CAdESSignature;
import eu.europa.esig.dss.enumerations.ASiCContainerType;
import eu.europa.esig.dss.enumerations.ArchiveTimestampType;
import eu.europa.esig.dss.enumerations.TimestampType;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.InMemoryDocument;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.DocumentValidator;
import eu.europa.esig.dss.validation.ManifestEntry;
import eu.europa.esig.dss.validation.ManifestFile;
import eu.europa.esig.dss.validation.timestamp.TimestampToken;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ASiCContainerWithCAdESValidator
extends AbstractASiCContainerValidator {
    private static final Logger LOG = LoggerFactory.getLogger(ASiCContainerWithCAdESValidator.class);

    ASiCContainerWithCAdESValidator() {
        super((DSSDocument)null);
    }

    public ASiCContainerWithCAdESValidator(DSSDocument asicContainer) {
        super(asicContainer);
        this.analyseEntries();
    }

    @Override
    public boolean isSupported(DSSDocument dssDocument) {
        return ASiCUtils.isASiCContainer(dssDocument) && ASiCUtils.isArchiveContainsCorrectSignatureFileWithExtension(dssDocument, ".p7s");
    }

    @Override
    protected AbstractASiCContainerExtractor getArchiveExtractor() {
        return new ASiCWithCAdESContainerExtractor(this.document);
    }

    @Override
    protected List<DocumentValidator> getValidators() {
        if (this.validators == null) {
            this.validators = new ArrayList();
            for (DSSDocument signature : this.getSignatureDocuments()) {
                CMSDocumentForASiCValidator cadesValidator = new CMSDocumentForASiCValidator(signature);
                cadesValidator.setCertificateVerifier(this.certificateVerifier);
                cadesValidator.setProcessExecutor(this.processExecutor);
                cadesValidator.setSignaturePolicyProvider(this.signaturePolicyProvider);
                cadesValidator.setValidationCertPool(this.validationCertPool);
                cadesValidator.setDetachedContents(this.getSignedDocuments(signature));
                cadesValidator.setContainerContents(this.getArchiveDocuments());
                cadesValidator.setManifestFiles(this.getManifestFiles());
                this.validators.add(cadesValidator);
            }
        }
        return this.validators;
    }

    @Override
    protected List<DSSDocument> getArchiveDocuments() {
        List<DSSDocument> archiveContents = super.getArchiveDocuments();
        if (Utils.isCollectionNotEmpty(this.getManifestDocuments())) {
            for (DSSDocument document : this.getSignedDocuments()) {
                if (archiveContents.contains(document)) continue;
                archiveContents.add(document);
            }
        }
        return archiveContents;
    }

    @Override
    protected List<TimestampToken> attachExternalTimestamps(List<AdvancedSignature> allSignatures) {
        ArrayList<TimestampToken> externalTimestamps = new ArrayList<TimestampToken>();
        ASiCContainerType type = this.getContainerType();
        if (ASiCContainerType.ASiC_E == type) {
            List<ASiCEWithCAdESTimestampValidator> currentTimestampValidators = this.getTimestampValidators();
            for (ASiCEWithCAdESTimestampValidator tspValidator : currentTimestampValidators) {
                TimestampToken timestamp = this.getExternalTimestamp(tspValidator, allSignatures);
                if (timestamp == null) continue;
                externalTimestamps.add(timestamp);
            }
        }
        return externalTimestamps;
    }

    private TimestampToken getExternalTimestamp(ASiCEWithCAdESTimestampValidator tspValidator, List<AdvancedSignature> allSignatures) {
        List<ManifestEntry> coveredFiles = tspValidator.getCoveredFilenames();
        TimestampToken timestamp = tspValidator.getTimestamp();
        this.findTimestampTokenSigner(timestamp);
        if (timestamp.isSignatureValid()) {
            for (AdvancedSignature advancedSignature : allSignatures) {
                for (ManifestEntry entry : coveredFiles) {
                    if (entry.getFileName() == null || !entry.getFileName().contains(advancedSignature.getSignatureFilename())) continue;
                    CAdESSignature cadesSig = (CAdESSignature)advancedSignature;
                    ArrayList<TimestampToken> cadesTimestamps = new ArrayList<TimestampToken>();
                    cadesTimestamps.addAll(cadesSig.getContentTimestamps());
                    cadesTimestamps.addAll(cadesSig.getSignatureTimestamps());
                    cadesTimestamps.addAll(cadesSig.getTimestampsX1());
                    cadesTimestamps.addAll(cadesSig.getTimestampsX2());
                    timestamp.setArchiveTimestampType(ArchiveTimestampType.CAdES_DETACHED);
                    timestamp.getTimestampedReferences().addAll(cadesSig.getTimestampReferencesForArchiveTimestamp(cadesTimestamps));
                    advancedSignature.addExternalTimestamp(timestamp);
                    return timestamp;
                }
            }
        }
        return null;
    }

    private void findTimestampTokenSigner(TimestampToken timestamp) {
        List<CertificateToken> certificates = timestamp.getCertificates();
        for (CertificateToken candidate : certificates) {
            if (timestamp.isSignedBy(candidate)) break;
        }
    }

    private List<ASiCEWithCAdESTimestampValidator> getTimestampValidators() {
        ArrayList<ASiCEWithCAdESTimestampValidator> timestampValidators = new ArrayList<ASiCEWithCAdESTimestampValidator>();
        for (DSSDocument timestamp : this.getTimestampDocuments()) {
            DSSDocument archiveManifest = ASiCEWithCAdESManifestParser.getLinkedManifest(this.getArchiveManifestDocuments(), timestamp.getName());
            if (archiveManifest != null) {
                ManifestFile manifestContent = ASiCEWithCAdESManifestParser.getManifestFile(archiveManifest);
                ASiCEWithCAdESTimestampValidator timestampValidator = new ASiCEWithCAdESTimestampValidator(timestamp, TimestampType.ARCHIVE_TIMESTAMP, manifestContent.getEntries(), this.validationCertPool);
                timestampValidator.setCertificateVerifier(this.certificateVerifier);
                timestampValidator.setTimestampedData(archiveManifest);
                timestampValidators.add(timestampValidator);
                continue;
            }
            LOG.warn("Timestamp {} is skipped (no linked archive manifest found)", (Object)timestamp.getName());
        }
        return timestampValidators;
    }

    private List<DSSDocument> getSignedDocuments(DSSDocument signature) {
        ASiCContainerType type = this.getContainerType();
        if (ASiCContainerType.ASiC_S.equals((Object)type)) {
            return this.getSignedDocuments();
        }
        if (ASiCContainerType.ASiC_E.equals((Object)type)) {
            DSSDocument linkedManifest = ASiCEWithCAdESManifestParser.getLinkedManifest(this.getManifestDocuments(), signature.getName());
            if (linkedManifest != null) {
                return Arrays.asList(linkedManifest);
            }
            return Collections.singletonList(new InMemoryDocument(new byte[0]));
        }
        LOG.warn("Unknown asic container type (returns all signed documents)");
        return this.getSignedDocuments();
    }

    @Override
    protected List<ManifestFile> getManifestFilesDecriptions() {
        ArrayList<ManifestFile> descriptions = new ArrayList<ManifestFile>();
        List<DSSDocument> manifestDocuments = this.getManifestDocuments();
        for (DSSDocument manifestDocument : manifestDocuments) {
            ManifestFile manifestFile = ASiCEWithCAdESManifestParser.getManifestFile(manifestDocument);
            if (manifestFile == null) continue;
            ASiCEWithCAdESManifestValidator asiceWithCAdESManifestValidator = new ASiCEWithCAdESManifestValidator(manifestFile, this.getSignedDocuments());
            asiceWithCAdESManifestValidator.validateEntries();
            descriptions.add(manifestFile);
        }
        List<DSSDocument> archiveManifestDocuments = this.getArchiveManifestDocuments();
        for (DSSDocument manifestDocument : archiveManifestDocuments) {
            ManifestFile manifestFile = ASiCEWithCAdESManifestParser.getManifestFile(manifestDocument);
            if (manifestFile == null) continue;
            manifestFile.setArchiveManifest(true);
            ASiCEWithCAdESManifestValidator asiceWithCAdESManifestValidator = new ASiCEWithCAdESManifestValidator(manifestFile, this.getSignedDocuments());
            asiceWithCAdESManifestValidator.validateEntries();
            descriptions.add(manifestFile);
        }
        return descriptions;
    }

    @Override
    public List<DSSDocument> getOriginalDocuments(String signatureId) {
        List<AdvancedSignature> signatures = this.getSignatures();
        for (AdvancedSignature signature : signatures) {
            if (!signature.getId().equals(signatureId)) continue;
            return this.getOriginalDocuments(signature);
        }
        return Collections.emptyList();
    }

    @Override
    public List<DSSDocument> getOriginalDocuments(AdvancedSignature advancedSignature) {
        List<DSSDocument> retrievedDocs = advancedSignature.getDetachedContents();
        if (ASiCContainerType.ASiC_S.equals((Object)this.getContainerType())) {
            return this.getSignedDocumentsASiCS(retrievedDocs);
        }
        DSSDocument linkedManifest = ASiCEWithCAdESManifestParser.getLinkedManifest(this.getManifestDocuments(), advancedSignature.getSignatureFilename());
        if (linkedManifest == null) {
            return Collections.emptyList();
        }
        ManifestFile manifestFile = ASiCEWithCAdESManifestParser.getManifestFile(linkedManifest);
        List<ManifestEntry> entries = manifestFile.getEntries();
        List<DSSDocument> signedDocuments = this.getSignedDocuments();
        ArrayList<DSSDocument> result = new ArrayList<DSSDocument>();
        for (ManifestEntry entry : entries) {
            for (DSSDocument signedDocument : signedDocuments) {
                if (!Utils.areStringsEqual(entry.getFileName(), signedDocument.getName())) continue;
                result.add(signedDocument);
            }
        }
        return result;
    }
}

