/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.asic.cades.signature.asice;

import eu.europa.esig.dss.DomUtils;
import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.MimeType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public abstract class AbstractManifestBuilder {
    protected void addSigReference(Document documentDom, Element asicManifestDom, String uri, MimeType mimeType) {
        Element sigReferenceDom = DomUtils.addElement(documentDom, asicManifestDom, "http://uri.etsi.org/02918/v1.2.1#", "asic:SigReference");
        sigReferenceDom.setAttribute("URI", uri);
        sigReferenceDom.setAttribute("MimeType", mimeType.getMimeTypeString());
    }

    protected Element addDataObjectReference(Document documentDom, Element asicManifestDom, DSSDocument document, DigestAlgorithm digestAlgorithm) {
        Element dataObjectReferenceDom = DomUtils.addElement(documentDom, asicManifestDom, "http://uri.etsi.org/02918/v1.2.1#", "asic:DataObjectReference");
        dataObjectReferenceDom.setAttribute("URI", document.getName());
        MimeType mimeType = document.getMimeType();
        if (mimeType != null) {
            dataObjectReferenceDom.setAttribute("MimeType", mimeType.getMimeTypeString());
        }
        Element digestMethodDom = DomUtils.addElement(documentDom, dataObjectReferenceDom, "http://www.w3.org/2000/09/xmldsig#", "ds:DigestMethod");
        digestMethodDom.setAttribute("Algorithm", digestAlgorithm.getUri());
        Element digestValueDom = DomUtils.addElement(documentDom, dataObjectReferenceDom, "http://www.w3.org/2000/09/xmldsig#", "ds:DigestValue");
        Text textNode = documentDom.createTextNode(document.getDigest(digestAlgorithm));
        digestValueDom.appendChild(textNode);
        return dataObjectReferenceDom;
    }
}

